
package oasis.names.tc.saml._2_0.assertion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * <p>Java class for AttributeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AttributeType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{urn:oasis:names:tc:SAML:2.0:assertion}AttributeValue" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="Name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="NameFormat" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&gt;
 *       &lt;attribute name="FriendlyName" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;anyAttribute processContents='lax' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AttributeType", propOrder = {
    "attributeValue"
})
public class AttributeType {

    @XmlElement(name = "AttributeValue", nillable = true)
    protected List<Object> attributeValue;
    @XmlAttribute(name = "Name", required = true)
    protected String name;
    @XmlAttribute(name = "NameFormat")
    @XmlSchemaType(name = "anyURI")
    protected String nameFormat;
    @XmlAttribute(name = "FriendlyName")
    protected String friendlyName;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Gets the value of the attributeValue property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a <CODE>set</CODE> method for the attributeValue property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttributeValue().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * 
     * 
     */
    public List<Object> getAttributeValue() {
        if (attributeValue == null) {
            attributeValue = new ArrayList<Object>();
        }
        return this.attributeValue;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the nameFormat property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNameFormat() {
        return nameFormat;
    }

    /**
     * Sets the value of the nameFormat property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNameFormat(String value) {
        this.nameFormat = value;
    }

    /**
     * Gets the value of the friendlyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFriendlyName() {
        return friendlyName;
    }

    /**
     * Sets the value of the friendlyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFriendlyName(String value) {
        this.friendlyName = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public AttributeType withAttributeValue(Object... values) {
        if (values!= null) {
            for (Object value: values) {
                getAttributeValue().add(value);
            }
        }
        return this;
    }

    public AttributeType withAttributeValue(Collection<Object> values) {
        if (values!= null) {
            getAttributeValue().addAll(values);
        }
        return this;
    }

    public AttributeType withName(String value) {
        setName(value);
        return this;
    }

    public AttributeType withNameFormat(String value) {
        setNameFormat(value);
        return this;
    }

    public AttributeType withFriendlyName(String value) {
        setFriendlyName(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final AttributeType that = ((AttributeType) object);
        {
            List<Object> leftAttributeValue;
            leftAttributeValue = (((this.attributeValue!= null)&&(!this.attributeValue.isEmpty()))?this.getAttributeValue():null);
            List<Object> rightAttributeValue;
            rightAttributeValue = (((that.attributeValue!= null)&&(!that.attributeValue.isEmpty()))?that.getAttributeValue():null);
            if ((this.attributeValue!= null)&&(!this.attributeValue.isEmpty())) {
                if ((that.attributeValue!= null)&&(!that.attributeValue.isEmpty())) {
                    if (!leftAttributeValue.equals(rightAttributeValue)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.attributeValue!= null)&&(!that.attributeValue.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftName;
            leftName = this.getName();
            String rightName;
            rightName = that.getName();
            if (this.name!= null) {
                if (that.name!= null) {
                    if (!leftName.equals(rightName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.name!= null) {
                    return false;
                }
            }
        }
        {
            String leftNameFormat;
            leftNameFormat = this.getNameFormat();
            String rightNameFormat;
            rightNameFormat = that.getNameFormat();
            if (this.nameFormat!= null) {
                if (that.nameFormat!= null) {
                    if (!leftNameFormat.equals(rightNameFormat)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.nameFormat!= null) {
                    return false;
                }
            }
        }
        {
            String leftFriendlyName;
            leftFriendlyName = this.getFriendlyName();
            String rightFriendlyName;
            rightFriendlyName = that.getFriendlyName();
            if (this.friendlyName!= null) {
                if (that.friendlyName!= null) {
                    if (!leftFriendlyName.equals(rightFriendlyName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.friendlyName!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<Object> theAttributeValue;
            theAttributeValue = (((this.attributeValue!= null)&&(!this.attributeValue.isEmpty()))?this.getAttributeValue():null);
            if ((this.attributeValue!= null)&&(!this.attributeValue.isEmpty())) {
                currentHashCode += theAttributeValue.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theName;
            theName = this.getName();
            if (this.name!= null) {
                currentHashCode += theName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theNameFormat;
            theNameFormat = this.getNameFormat();
            if (this.nameFormat!= null) {
                currentHashCode += theNameFormat.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theFriendlyName;
            theFriendlyName = this.getFriendlyName();
            if (this.friendlyName!= null) {
                currentHashCode += theFriendlyName.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
