
package oasis.names.tc.dss._1_0.core.schema;

import java.math.BigInteger;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.tc.saml._1_0.assertion.NameIdentifierType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.cxf.xjc.runtime.JAXBToStringStyle;


/**
 * <p>Java class for anonymous complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="SerialNumber" type="{http://www.w3.org/2001/XMLSchema}integer"/&gt;
 *         &lt;element name="CreationTime" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&gt;
 *         &lt;element name="Policy" type="{http://www.w3.org/2001/XMLSchema}anyURI" minOccurs="0"/&gt;
 *         &lt;element name="ErrorBound" type="{http://www.w3.org/2001/XMLSchema}duration" minOccurs="0"/&gt;
 *         &lt;element name="Ordered" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="TSA" type="{urn:oasis:names:tc:SAML:1.0:assertion}NameIdentifierType" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "serialNumber",
    "creationTime",
    "policy",
    "errorBound",
    "ordered",
    "tsa"
})
@XmlRootElement(name = "TstInfo")
public class TstInfo {

    @XmlElement(name = "SerialNumber", required = true)
    protected BigInteger serialNumber;
    @XmlElement(name = "CreationTime", required = true)
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar creationTime;
    @XmlElement(name = "Policy")
    @XmlSchemaType(name = "anyURI")
    protected String policy;
    @XmlElement(name = "ErrorBound")
    protected Duration errorBound;
    @XmlElement(name = "Ordered", defaultValue = "false")
    protected Boolean ordered;
    @XmlElement(name = "TSA")
    protected NameIdentifierType tsa;

    /**
     * Gets the value of the serialNumber property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    public BigInteger getSerialNumber() {
        return serialNumber;
    }

    /**
     * Sets the value of the serialNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setSerialNumber(BigInteger value) {
        this.serialNumber = value;
    }

    /**
     * Gets the value of the creationTime property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getCreationTime() {
        return creationTime;
    }

    /**
     * Sets the value of the creationTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCreationTime(XMLGregorianCalendar value) {
        this.creationTime = value;
    }

    /**
     * Gets the value of the policy property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPolicy() {
        return policy;
    }

    /**
     * Sets the value of the policy property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPolicy(String value) {
        this.policy = value;
    }

    /**
     * Gets the value of the errorBound property.
     * 
     * @return
     *     possible object is
     *     {@link Duration }
     *     
     */
    public Duration getErrorBound() {
        return errorBound;
    }

    /**
     * Sets the value of the errorBound property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     */
    public void setErrorBound(Duration value) {
        this.errorBound = value;
    }

    /**
     * Gets the value of the ordered property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isOrdered() {
        return ordered;
    }

    /**
     * Sets the value of the ordered property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOrdered(Boolean value) {
        this.ordered = value;
    }

    /**
     * Gets the value of the tsa property.
     * 
     * @return
     *     possible object is
     *     {@link NameIdentifierType }
     *     
     */
    public NameIdentifierType getTSA() {
        return tsa;
    }

    /**
     * Sets the value of the tsa property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameIdentifierType }
     *     
     */
    public void setTSA(NameIdentifierType value) {
        this.tsa = value;
    }

    public TstInfo withSerialNumber(BigInteger value) {
        setSerialNumber(value);
        return this;
    }

    public TstInfo withCreationTime(XMLGregorianCalendar value) {
        setCreationTime(value);
        return this;
    }

    public TstInfo withPolicy(String value) {
        setPolicy(value);
        return this;
    }

    public TstInfo withErrorBound(Duration value) {
        setErrorBound(value);
        return this;
    }

    public TstInfo withOrdered(Boolean value) {
        setOrdered(value);
        return this;
    }

    public TstInfo withTSA(NameIdentifierType value) {
        setTSA(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final TstInfo that = ((TstInfo) object);
        {
            BigInteger leftSerialNumber;
            leftSerialNumber = this.getSerialNumber();
            BigInteger rightSerialNumber;
            rightSerialNumber = that.getSerialNumber();
            if (this.serialNumber!= null) {
                if (that.serialNumber!= null) {
                    if (!leftSerialNumber.equals(rightSerialNumber)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.serialNumber!= null) {
                    return false;
                }
            }
        }
        {
            XMLGregorianCalendar leftCreationTime;
            leftCreationTime = this.getCreationTime();
            XMLGregorianCalendar rightCreationTime;
            rightCreationTime = that.getCreationTime();
            if (this.creationTime!= null) {
                if (that.creationTime!= null) {
                    if (!leftCreationTime.equals(rightCreationTime)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.creationTime!= null) {
                    return false;
                }
            }
        }
        {
            String leftPolicy;
            leftPolicy = this.getPolicy();
            String rightPolicy;
            rightPolicy = that.getPolicy();
            if (this.policy!= null) {
                if (that.policy!= null) {
                    if (!leftPolicy.equals(rightPolicy)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.policy!= null) {
                    return false;
                }
            }
        }
        {
            Duration leftErrorBound;
            leftErrorBound = this.getErrorBound();
            Duration rightErrorBound;
            rightErrorBound = that.getErrorBound();
            if (this.errorBound!= null) {
                if (that.errorBound!= null) {
                    if (!leftErrorBound.equals(rightErrorBound)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.errorBound!= null) {
                    return false;
                }
            }
        }
        {
            Boolean leftOrdered;
            leftOrdered = this.isOrdered();
            Boolean rightOrdered;
            rightOrdered = that.isOrdered();
            if (this.ordered!= null) {
                if (that.ordered!= null) {
                    if (!leftOrdered.equals(rightOrdered)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.ordered!= null) {
                    return false;
                }
            }
        }
        {
            NameIdentifierType leftTSA;
            leftTSA = this.getTSA();
            NameIdentifierType rightTSA;
            rightTSA = that.getTSA();
            if (this.tsa!= null) {
                if (that.tsa!= null) {
                    if (!leftTSA.equals(rightTSA)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.tsa!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theSerialNumber;
            theSerialNumber = this.getSerialNumber();
            if (this.serialNumber!= null) {
                currentHashCode += theSerialNumber.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            XMLGregorianCalendar theCreationTime;
            theCreationTime = this.getCreationTime();
            if (this.creationTime!= null) {
                currentHashCode += theCreationTime.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String thePolicy;
            thePolicy = this.getPolicy();
            if (this.policy!= null) {
                currentHashCode += thePolicy.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Duration theErrorBound;
            theErrorBound = this.getErrorBound();
            if (this.errorBound!= null) {
                currentHashCode += theErrorBound.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Boolean theOrdered;
            theOrdered = this.isOrdered();
            if (this.ordered!= null) {
                currentHashCode += theOrdered.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            NameIdentifierType theTSA;
            theTSA = this.getTSA();
            if (this.tsa!= null) {
                currentHashCode += theTSA.hashCode();
            }
        }
        return currentHashCode;
    }

    /**
     * Generates a String representation of the contents of this type.
     * This is an extension method, produced by the 'ts' xjc plugin
     * 
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, JAXBToStringStyle.DEFAULT_STYLE);
    }

}
