/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.demis;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.test.web.server.LocalServerPort;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
public abstract class AbstractOpenApiSpecDownloaderTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractOpenApiSpecDownloaderTest.class);
    @LocalServerPort
    private int port;
    @Autowired
    private TestRestTemplate restTemplate;
    @Value(value="#{systemProperties.openapi_generator_inputSpec}")
    private String openapiSpecPath;
    @Value(value="${springdoc.api-docs.path:/v3/api-docs}")
    private String springdocApidocsPath;

    @Test
    void startAppAndRetrieveOpenApiSpec() {
        ResponseEntity response = this.restTemplate.getForEntity("http://localhost:" + this.port + this.springdocApidocsPath + ".yaml", String.class, new Object[0]);
        Assertions.assertThat((Object)response.getStatusCode()).matches(HttpStatusCode::is2xxSuccessful, "Status code must be a 2xx code");
        String openapiSpec = (String)response.getBody();
        Assertions.assertThat((String)openapiSpec).isNotEmpty();
        log.info("OpenAPI spec will be saved to: {}", (Object)this.openapiSpecPath);
        try {
            Files.createDirectories(Paths.get(this.openapiSpecPath, new String[0]).getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create openapi spec path", e);
        }
        try (FileOutputStream fout = new FileOutputStream(this.openapiSpecPath);){
            fout.write(openapiSpec.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("failed to save generated openapi spec", e);
        }
    }
}

