/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.demis.fhirparserlibrary;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import de.gematik.demis.fhirparserlibrary.MessageType;
import de.gematik.demis.fhirparserlibrary.ParsingException;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Parameters;

public class FhirParser {
    public static final String UNSUPPORTED_RESOURCE_BUNDLE = "Unsupported resource bundle";
    private final IParser xmlParser;
    private final IParser jsonParser;

    public FhirParser(FhirContext fhirContext) {
        this.xmlParser = fhirContext.newXmlParser();
        this.jsonParser = fhirContext.newJsonParser();
    }

    public Bundle parseBundleOrParameter(String content, String messageType) {
        return this.parseBundleOrParameter(content, MessageType.getMessageType(messageType));
    }

    public Bundle parseBundleOrParameter(String content, MessageType messageType) throws ParsingException {
        IBaseResource resource = this.getParser(messageType).parseResource(content);
        if (resource instanceof Parameters) {
            Parameters parameters = (Parameters)resource;
            return (Bundle)parameters.getParameterFirstRep().getResource();
        }
        if (resource instanceof Bundle) {
            return (Bundle)resource;
        }
        throw new ParsingException(UNSUPPORTED_RESOURCE_BUNDLE);
    }

    public IBaseResource parseFromJson(String content) {
        return this.jsonParser.parseResource(content);
    }

    public IBaseResource parseFromXml(String content) {
        return this.xmlParser.parseResource(content);
    }

    public String encode(IBaseResource resource, String messageType) {
        return this.getParser(MessageType.getMessageType(messageType)).encodeResourceToString(resource);
    }

    public String encode(IBaseResource resource, MessageType messageType) {
        return this.getParser(messageType).encodeResourceToString(resource);
    }

    public String encodeToJson(IBaseResource resource) {
        return this.jsonParser.encodeResourceToString(resource);
    }

    public String encodeToXml(IBaseResource resource) {
        return this.xmlParser.encodeResourceToString(resource);
    }

    private IParser getParser(MessageType messageType) {
        Objects.requireNonNull(messageType, "require NonNull mediaType");
        if (messageType.equals((Object)MessageType.XML)) {
            return this.xmlParser;
        }
        return this.jsonParser;
    }
}

