package de.gematik.demis.token.data;

/*-
 * #%L
 * DEMIS Commons Library
 * %%
 * Copyright (C) 2025 gematik GmbH
 * %%
 * Licensed under the EUPL, Version 1.2 or - as soon they will be approved by the
 * European Commission – subsequent versions of the EUPL (the "Licence").
 * You may not use this work except in compliance with the Licence.
 *
 * You find a copy of the Licence in the "Licence" file or at
 * https://joinup.ec.europa.eu/collection/eupl/eupl-text-eupl-12
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an "AS IS" basis,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either expressed or implied.
 * In case of changes by gematik find details in the "Readme" file.
 *
 * See the Licence for the specific language governing permissions and limitations under the Licence.
 * #L%
 */

import de.gematik.demis.enums.ProxyProtocolEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NonNull;

/**
 * Holds the Proxy Configurations. Please use the {@link de.gematik.demis.proxy.ProxySettings}
 * class.
 */
@Data
@Builder
@AllArgsConstructor
@Deprecated(forRemoval = true, since = "3.0.0")
public class ProxyConfiguration {

  @NonNull private final ProxyProtocolEnum protocol;

  @NonNull private final String host;
  @NonNull private final int port;

  private final String username;
  private final String password;
}
