package de.gematik.demis.enums;

/*-
 * #%L
 * DEMIS Commons Library
 * %%
 * Copyright (C) 2025 gematik GmbH
 * %%
 * Licensed under the EUPL, Version 1.2 or - as soon they will be approved by the
 * European Commission – subsequent versions of the EUPL (the "Licence").
 * You may not use this work except in compliance with the Licence.
 *
 * You find a copy of the Licence in the "Licence" file or at
 * https://joinup.ec.europa.eu/collection/eupl/eupl-text-eupl-12
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an "AS IS" basis,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either expressed or implied.
 * In case of changes by gematik find details in the "Readme" file.
 *
 * See the Licence for the specific language governing permissions and limitations under the Licence.
 * #L%
 */

/** Defines the Keystore Type. */
public enum KeyStoreType {
  JKS("jks"),
  PKCS12("p12");

  private final String extension;

  KeyStoreType(String extension) {
    this.extension = extension;
  }

  /**
   * Returns the Keystore Type as string.
   *
   * @return converts the type to string
   */
  @Override
  public String toString() {
    return this.name();
  }

  /**
   * Returns the extension of the type.
   *
   * @return one between "jks" or "p12"
   */
  public String toExtension() {
    return this.extension;
  }
}
