/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.utils.request;

import de.gematik.utils.Utils;
import de.gematik.utils.request.SSLContextFactory;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.MojoExecutionException;

public class ApiRequester {
    private String trustStorePath;
    private String clientCertPath;
    private String trustStorePassword;
    private String clientCertPassword;
    private OkHttpClient client;

    public String getApiResponse(String value) throws MojoExecutionException {
        String string;
        block9: {
            if (this.client == null) {
                this.setupAndCreateClient();
            }
            Request request = new Request.Builder().url(value).build();
            ResponseBody body = this.client.newCall(request).execute().body();
            try {
                string = body.string();
                if (body == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("API did not respond -> " + value + " cause: " + e.getMessage());
                }
            }
            body.close();
        }
        return string;
    }

    private void setupAndCreateClient() {
        block4: {
            if (this.trustStorePath != null && this.trustStorePassword != null && this.clientCertPath != null && this.clientCertPassword != null) {
                SSLContext sslContext = SSLContextFactory.createAndGetSSLContext(this.clientCertPath, this.trustStorePath, this.clientCertPassword, this.trustStorePassword);
                this.client = new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory()).build();
                Utils.getLog().info((CharSequence)"Using mTLS");
                break block4;
            }
            if (this.trustStorePath == null && this.trustStorePassword == null && this.clientCertPath == null && this.clientCertPassword == null) {
                this.client = new OkHttpClient.Builder().build();
                Utils.getLog().warn((CharSequence)"Using no TLS");
                break block4;
            }
            throw new MojoExecutionException("You tried to set an mTLS context but one information is missing");
        }
    }

    public void setupTls(String trustStorePath, String trustStorePassword, String clientCertPath, String clientCertPassword) {
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.clientCertPath = clientCertPath;
        this.clientCertPassword = clientCertPassword;
        this.setupAndCreateClient();
    }
}

