/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.tags;

import de.gematik.combine.CombineConfiguration;
import de.gematik.combine.FilterConfiguration;
import de.gematik.combine.ProjectFilters;
import de.gematik.combine.filter.ConfigFilterMapper;
import de.gematik.combine.filter.Filters;
import de.gematik.combine.filter.table.TableFilter;
import de.gematik.combine.filter.table.cell.CellFilter;
import de.gematik.combine.filter.table.row.RowFilter;
import de.gematik.combine.filter.table.row.TableRowFilter;
import de.gematik.combine.tags.ConfigModifier;
import de.gematik.combine.tags.ConfiguredFilters;
import de.gematik.combine.util.NonNullableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class ParsedTags {
    private final List<String> columns;
    private final List<ConfigModifier> configModifiers = new ArrayList<ConfigModifier>();
    private final Filters filters = new Filters();

    public void addConfigModifier(ConfigModifier configurationTag) {
        this.configModifiers.add(configurationTag);
    }

    public FilterConfiguration getActualConfig(FilterConfiguration defaultConfig) {
        return (FilterConfiguration)this.configModifiers.stream().reduce(x -> x, ConfigModifier::merge).apply(defaultConfig);
    }

    public ConfiguredFilters configureFilters(CombineConfiguration config) {
        FilterConfiguration actualConfig = this.getActualConfig(config.getFilterConfiguration());
        Filters allFilters = ConfigFilterMapper.toFilters(actualConfig);
        this.getTableFilters().forEach(allFilters::addTableFilter);
        this.getTableRowFilters().forEach(allFilters::addTableRowFilter);
        this.getCellFilters().forEach(allFilters::addCellFilter);
        this.checkAndAddProjectFilters(config, allFilters);
        return new ConfiguredFilters(actualConfig, this.columns, allFilters);
    }

    public List<String> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<ConfigModifier> getConfigModifiers() {
        return Collections.unmodifiableList(this.configModifiers);
    }

    private void checkAndAddProjectFilters(CombineConfiguration config, Filters allFilters) {
        ProjectFilters projectFilters = config.getProjectFilters();
        if (Objects.nonNull(projectFilters)) {
            ParsedTags.addRowFilters(allFilters, projectFilters);
            this.columns.forEach(header -> ParsedTags.addCellFilters(header, allFilters, projectFilters));
        }
    }

    private static void addRowFilters(Filters allFilters, ProjectFilters projectFilters) {
        projectFilters.getRowFilters().stream().filter(rowFilter -> ParsedTags.isFilterOverriddenInScenario(rowFilter, allFilters, null)).forEach(allFilters::addTableRowFilter);
    }

    private static void addCellFilters(String header, Filters allFilters, ProjectFilters projectFilters) {
        projectFilters.getCellFilters().stream().filter(cellFilter -> ParsedTags.isFilterOverriddenInScenario(cellFilter, allFilters, header)).forEach(cellFilter -> allFilters.addCellFilter(header, (CellFilter)cellFilter));
    }

    private static boolean isFilterOverriddenInScenario(Object filter, Filters allFilters, String header) {
        if (Objects.nonNull(header)) {
            return NonNullableMap.nonNullableMap(allFilters.getCellFilters(), x -> Collections.emptyList()).get(header).stream().noneMatch(filter.getClass().getSuperclass()::isInstance);
        }
        return allFilters.getTableRowFilters().stream().noneMatch(filter.getClass().getSuperclass()::isInstance);
    }

    @Generated
    public ParsedTags(List<String> columns) {
        this.columns = columns;
    }

    @Generated
    public void addTableFilter(TableFilter tableFilter) {
        this.filters.addTableFilter(tableFilter);
    }

    @Generated
    public void addTableRowFilter(TableRowFilter tableRowFilter) {
        this.filters.addTableRowFilter(tableRowFilter);
    }

    @Generated
    public void addCellFilter(String header, CellFilter newCellFilter) {
        this.filters.addCellFilter(header, newCellFilter);
    }

    @Generated
    public void addCellFilter(String header, List<CellFilter> newCellFilter) {
        this.filters.addCellFilter(header, newCellFilter);
    }

    @Generated
    public List<TableFilter> getTableFilters() {
        return this.filters.getTableFilters();
    }

    @Generated
    public List<TableRowFilter> getTableRowFilters() {
        return this.filters.getTableRowFilters();
    }

    @Generated
    public Map<String, List<CellFilter>> getCellFilters() {
        return this.filters.getCellFilters();
    }

    @Generated
    public RowFilter combineAllRowFilters() {
        return this.filters.combineAllRowFilters();
    }

    @Generated
    public Map<String, CellFilter> combineCellFilters() {
        return this.filters.combineCellFilters();
    }
}

