/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.tags;

import de.gematik.combine.FilterConfiguration;
import de.gematik.combine.filter.Filters;
import de.gematik.combine.filter.table.TableFilter;
import de.gematik.combine.filter.table.cell.CellFilter;
import de.gematik.combine.filter.table.row.RowFilter;
import de.gematik.combine.filter.table.row.TableRowFilter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public class ConfiguredFilters {
    private final FilterConfiguration actualConfig;
    private final List<String> columns;
    private final Filters filters;

    public TableFilter combineAllFilters() {
        return Stream.concat(this.getTableFilters().stream(), this.getTableRowFilters().stream()).sorted().reduce(x -> x, TableFilter::combine);
    }

    public List<String> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Generated
    public ConfiguredFilters(FilterConfiguration actualConfig, List<String> columns, Filters filters) {
        this.actualConfig = actualConfig;
        this.columns = columns;
        this.filters = filters;
    }

    @Generated
    public FilterConfiguration getActualConfig() {
        return this.actualConfig;
    }

    @Generated
    public void addTableFilter(TableFilter tableFilter) {
        this.filters.addTableFilter(tableFilter);
    }

    @Generated
    public void addTableRowFilter(TableRowFilter tableRowFilter) {
        this.filters.addTableRowFilter(tableRowFilter);
    }

    @Generated
    public void addCellFilter(String header, CellFilter newCellFilter) {
        this.filters.addCellFilter(header, newCellFilter);
    }

    @Generated
    public void addCellFilter(String header, List<CellFilter> newCellFilter) {
        this.filters.addCellFilter(header, newCellFilter);
    }

    @Generated
    public List<TableFilter> getTableFilters() {
        return this.filters.getTableFilters();
    }

    @Generated
    public List<TableRowFilter> getTableRowFilters() {
        return this.filters.getTableRowFilters();
    }

    @Generated
    public Map<String, List<CellFilter>> getCellFilters() {
        return this.filters.getCellFilters();
    }

    @Generated
    public RowFilter combineAllRowFilters() {
        return this.filters.combineAllRowFilters();
    }

    @Generated
    public Map<String, CellFilter> combineCellFilters() {
        return this.filters.combineCellFilters();
    }
}

