/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter.table.row;

import de.gematik.combine.CombineMojo;
import de.gematik.combine.filter.FilterOrder;
import de.gematik.combine.filter.table.TableFilter;
import de.gematik.combine.filter.table.row.RowFilter;
import de.gematik.combine.model.TableCell;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class TableRowFilter
implements TableFilter,
RowFilter {
    public static final int CHUNK_SIZE = 1000000;

    @Override
    public List<List<TableCell>> apply(List<List<TableCell>> tableRows) {
        CombineMojo.getPluginLog().debug((CharSequence)String.format("applying %s on %d rows", this, tableRows.size()));
        ArrayList<List<TableCell>> result = new ArrayList<List<TableCell>>();
        int chunkCount = tableRows.size() / 1000000 + 1;
        for (int i = 0; i < tableRows.size(); i += 1000000) {
            List<List<TableCell>> chunk = tableRows.subList(i, Math.min(i + 1000000, tableRows.size()));
            List filteredChunk = chunk.stream().filter(this).collect(Collectors.toList());
            result.addAll(filteredChunk);
            if (chunkCount <= 1) continue;
            CombineMojo.getPluginLog().debug((CharSequence)String.format("processing chunk %d of %d", i / 1000000 + 1, chunkCount));
        }
        return result;
    }

    @Override
    public FilterOrder getFilterOrder() {
        return FilterOrder.ROW_ONLY;
    }
}

