/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter;

import de.gematik.combine.FilterConfiguration;
import de.gematik.combine.filter.Filters;
import de.gematik.combine.filter.table.DoubleLineupFilter;
import de.gematik.combine.filter.table.MaxRowsFilter;
import de.gematik.combine.filter.table.ShuffleTableFilter;
import de.gematik.combine.filter.table.TableFilter;
import de.gematik.combine.filter.table.row.SelfCombineFilter;
import de.gematik.combine.filter.table.row.TableRowFilter;
import java.util.List;

public class ConfigFilterMapper {
    private ConfigFilterMapper() {
    }

    public static Filters toFilters(FilterConfiguration config) {
        Filters filters = new Filters();
        ConfigFilterMapper.getRowFilters(config).forEach(filters::addTableRowFilter);
        ConfigFilterMapper.getTableFilters(config).forEach(filters::addTableFilter);
        return filters;
    }

    private static List<TableRowFilter> getRowFilters(FilterConfiguration config) {
        return List.of(new SelfCombineFilter(config.isAllowSelfCombine()));
    }

    private static List<TableFilter> getTableFilters(FilterConfiguration config) {
        return List.of(new ShuffleTableFilter(config.isShuffleCombinations()), new DoubleLineupFilter(config.isAllowDoubleLineup()), new MaxRowsFilter("" + config.getMaxTableRows()));
    }
}

