/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.check;

import de.gematik.BaseMojo;
import de.gematik.check.CheckExpression;
import de.gematik.combine.model.CombineItem;
import de.gematik.utils.Utils;
import de.gematik.utils.request.ApiRequester;
import io.cucumber.core.internal.com.fasterxml.jackson.core.JsonProcessingException;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;

@org.apache.maven.plugins.annotations.Mojo(name="check", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class CheckMojo
extends BaseMojo {
    private static CheckMojo instance;
    private final ApiRequester apiRequester;
    private final List<String> errors = new ArrayList<String>();
    @Parameter(property="checkPath")
    String checkPath;
    @Parameter(property="checkExpressions")
    List<CheckExpression> checkExpressions = new ArrayList<CheckExpression>();
    @Parameter(property="defaultCheckExpressions")
    String defaultCheckExpressions;
    @Parameter(name="skipCheck", defaultValue="false")
    boolean skipCheck;
    public static final JexlEngine JEXL_ENGINE;

    public void execute() {
        if (this.isSkip() || this.skipCheck) {
            this.getLog().warn((CharSequence)"Check items got skipped due configuration");
            return;
        }
        CheckMojo.setInstance(this);
        this.apiRequester.setupTls(this.getTruststore(), this.getTruststorePw(), this.getClientCertStore(), this.getClientCertStorePw());
        this.run();
    }

    public static Log getPluginLog() {
        return instance.getLog();
    }

    private void run() {
        List<CombineItem> items = Utils.getItemsToCombine(new File(this.getCombineItemsFile()), (Mojo)this, true);
        items.forEach(this::check);
        Utils.writeErrors(((Object)((Object)this)).getClass().getSimpleName(), this.errors);
        if (!this.errors.isEmpty()) {
            throw new MojoExecutionException("Something went wrong during api check! At least one of your api could not pass the check. See error log at " + GENERATED_COMBINE_ITEMS_DIR);
        }
    }

    private void check(CombineItem item) {
        JexlExpression expression;
        try {
            String expressionString = this.getExpression(item);
            this.getLog().info((CharSequence)String.format("Checking %s with expression \"%s\"", Utils.getItemAsString(item), expressionString.replace("\n", "")));
            expression = JEXL_ENGINE.createExpression(expressionString);
        }
        catch (JexlException | MojoExecutionException e) {
            this.getLog().error((CharSequence)e.getMessage());
            this.errors.add(e.getMessage());
            return;
        }
        try {
            Object url = item.getUrl() == null ? item.getValue() : item.getUrl();
            url = (String)url + "/" + this.checkPath;
            url = ((String)url).replaceAll("(?<!:)//", "/");
            Map<?, ?> jsonContext = this.getJsonContextFromApi((String)url);
            MapContext context = new MapContext();
            context.set("$", jsonContext);
            context.set("ITEM", (Object)item);
            if (Boolean.FALSE.equals(expression.evaluate((JexlContext)context))) {
                String errorMsg = String.format("Check fails for %s and expression \"%s\"", Utils.getItemAsString(item), expression);
                this.getLog().error((CharSequence)errorMsg);
                this.errors.add(errorMsg);
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)e.getMessage());
            this.errors.add(e.getMessage());
        }
        catch (JsonProcessingException e) {
            String errorMsg = String.format("Requested check endpoint for %s but was not well formatted", Utils.getItemAsString(item));
            this.getLog().error((CharSequence)errorMsg);
            this.errors.add(errorMsg);
        }
    }

    private String getExpression(CombineItem combineItem) throws MojoExecutionException {
        if (Objects.nonNull(combineItem.getCheckExpression())) {
            return combineItem.getCheckExpression();
        }
        return this.checkExpressions.stream().filter(e -> e.getId().equals(combineItem.getCheckExpressionId())).map(CheckExpression::getExpression).findFirst().orElse(this.getDefaultCheckExpressions(combineItem));
    }

    private String getDefaultCheckExpressions(CombineItem item) throws MojoExecutionException {
        if (Objects.nonNull(this.defaultCheckExpressions)) {
            return this.defaultCheckExpressions;
        }
        if (this.checkExpressions.isEmpty()) {
            String errorMsg = "For item " + Utils.getItemAsString(item) + " no checkExpression could be found!";
            this.getLog().error((CharSequence)errorMsg);
            throw new MojoExecutionException(errorMsg);
        }
        return this.checkExpressions.get(0).getExpression();
    }

    private Map<?, ?> getJsonContextFromApi(String url) throws MojoExecutionException, JsonProcessingException {
        return (Map)new ObjectMapper().readValue(this.apiRequester.getApiResponse(url), Map.class);
    }

    @Generated
    public void setCheckPath(String checkPath) {
        this.checkPath = checkPath;
    }

    @Generated
    public void setCheckExpressions(List<CheckExpression> checkExpressions) {
        this.checkExpressions = checkExpressions;
    }

    @Generated
    public void setDefaultCheckExpressions(String defaultCheckExpressions) {
        this.defaultCheckExpressions = defaultCheckExpressions;
    }

    @Generated
    public void setSkipCheck(boolean skipCheck) {
        this.skipCheck = skipCheck;
    }

    @Generated
    public ApiRequester getApiRequester() {
        return this.apiRequester;
    }

    @Generated
    public List<String> getErrors() {
        return this.errors;
    }

    @Generated
    public String getCheckPath() {
        return this.checkPath;
    }

    @Generated
    public List<CheckExpression> getCheckExpressions() {
        return this.checkExpressions;
    }

    @Generated
    public String getDefaultCheckExpressions() {
        return this.defaultCheckExpressions;
    }

    @Generated
    public boolean isSkipCheck() {
        return this.skipCheck;
    }

    @Inject
    @Generated
    public CheckMojo(ApiRequester apiRequester) {
        this.apiRequester = apiRequester;
    }

    @Generated
    public static void setInstance(CheckMojo instance) {
        CheckMojo.instance = instance;
    }

    @Generated
    public static CheckMojo getInstance() {
        return instance;
    }

    static {
        JEXL_ENGINE = new JexlBuilder().strict(true).silent(false).safe(false).create();
    }
}

