/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.prepare;

import de.gematik.BaseMojo;
import de.gematik.combine.model.CombineItem;
import de.gematik.prepare.ItemsCreator;
import de.gematik.prepare.PrepareItemsConfig;
import de.gematik.prepare.PropertyExpression;
import de.gematik.prepare.TagExpression;
import de.gematik.prepare.pooling.GroupMatchStrategyType;
import de.gematik.prepare.pooling.PoolGroup;
import de.gematik.prepare.pooling.PoolGroupParser;
import de.gematik.prepare.pooling.Pooler;
import de.gematik.utils.Utils;
import de.gematik.utils.request.ApiRequester;
import io.cucumber.core.internal.com.fasterxml.jackson.core.JsonProcessingException;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.json.JSONObject;

@Mojo(name="prepare-items", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class PrepareItemsMojo
extends BaseMojo {
    public static final String FAILED_REQ_WARN_MESSAGE = "=== Caution!!! The generated file contains less items than your input! ===\n             === This is because of the following errors: ===";
    public static final String CONFIG_FAIL_WARN_MESSAGE = "=== Caution!!! The generated file is significantly different from your input! ===\n          === This is because of the following config errors: ===";
    public static final String USED_GROUPS_PATH = GENERATED_COMBINE_ITEMS_DIR + File.separator + "usedGroups.json";
    private static PrepareItemsMojo instance;
    private final ApiRequester apiRequester;
    @Parameter(property="infoResourceLocation")
    String infoResourceLocation;
    @Parameter(property="tagExpressions")
    List<TagExpression> tagExpressions;
    @Parameter(property="propertyExpressions")
    List<PropertyExpression> propertyExpressions;
    @Parameter(property="poolGroups")
    List<PoolGroup> poolGroups;
    @Parameter(property="excludedGroups")
    List<String> excludedGroups;
    @Parameter(property="poolSize", defaultValue="0")
    int poolSize;
    @Parameter(property="poolGroupString")
    String poolGroupString;
    @Parameter(name="defaultMatchStrategy", defaultValue="WILDCARD")
    GroupMatchStrategyType defaultMatchStrategy;
    @Parameter(name="skipPrep", defaultValue="false")
    boolean skipPrep;
    private ItemsCreator itemsCreator;
    private List<CombineItem> items;
    private Pooler pooler;
    private PrepareItemsConfig config;

    public static Log getPluginLog() {
        return instance.getLog();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip() || this.skipPrep) {
            this.getLog().warn((CharSequence)"Preparation of items file got skipped due configuration");
            return;
        }
        PrepareItemsMojo.setInstance(this);
        this.checkExpressionSetCorrectly();
        this.getLog().info((CharSequence)("Going to preprocess " + this.getCombineItemsFile()));
        if (StringUtils.isNotBlank((CharSequence)this.poolGroupString)) {
            this.getLog().info((CharSequence)"String is used to create poolGroups. Overrides other configuration!");
            this.poolGroups = new PoolGroupParser().transformStringToGroups(this.poolGroupString);
        }
        this.setDefaultForEmptyStrategyInPoolGroups();
        this.config = this.getCreateItemsConfig();
        this.itemsCreator = new ItemsCreator(this.config);
        this.pooler = new Pooler(this.config);
        this.items = this.pooler.pool();
        this.writeUsedGroupsToFile(this.items);
        this.apiRequester.setupProxy(this.getProxyHost(), this.getProxyPort());
        this.apiRequester.setupTls(this.getTruststore(), this.getTruststorePw(), this.getClientCertStore(), this.getClientCertStorePw());
        this.apiRequester.setAllowedResponses(this.config.getAcceptedResponseFamilies(), this.config.getAllowedResponseCodes());
        this.run();
    }

    private void setDefaultForEmptyStrategyInPoolGroups() {
        this.poolGroups = this.poolGroups.stream().map(p -> {
            if (p.getStrategy() == null) {
                p.setStrategy(this.defaultMatchStrategy);
            }
            return p;
        }).collect(Collectors.toList());
    }

    protected void checkExpressionSetCorrectly() throws MojoExecutionException {
        Optional<TagExpression> checkTag = this.tagExpressions.stream().filter(t -> t.getExpression() == null || t.getTag() == null).findAny();
        if (checkTag.isPresent()) {
            throw new MojoExecutionException(String.format("Erroneous configuration: missing %s in %s", checkTag.get().getExpression() == null ? "expression" : "tag", checkTag.get()));
        }
        Optional<PropertyExpression> checkProperty = this.propertyExpressions.stream().filter(t -> t.getExpression() == null || t.getProperty() == null).findAny();
        if (checkProperty.isPresent()) {
            throw new MojoExecutionException(String.format("Erroneous configuration: missing %s in %s", checkProperty.get().getExpression() == null ? "expression" : "property", checkProperty.get()));
        }
    }

    protected void run() throws MojoExecutionException {
        List<CombineItem> processedItems = this.items.stream().map(this::processItem).filter(Objects::nonNull).collect(Collectors.toList());
        boolean requestsOk = this.apiErrors.isEmpty() || !this.isBreakOnFailedRequest();
        boolean contextOk = this.itemsCreator.getContextErrors().isEmpty() || !this.isBreakOnContextError();
        Utils.writeErrors(((Object)((Object)this)).getClass().getSimpleName(), this.apiErrors, FAILED_REQ_WARN_MESSAGE, false);
        Utils.writeErrors(((Object)((Object)this)).getClass().getSimpleName(), this.itemsCreator.getContextErrors(), CONFIG_FAIL_WARN_MESSAGE, this.apiErrors.isEmpty());
        if (requestsOk && contextOk) {
            this.getLog().info((CharSequence)String.format("Successfully processed %s items, writing to file %s", processedItems.size(), this.getCombineItemsFile()));
            this.writeItemsToFile(processedItems);
        }
        if (!requestsOk) {
            throw new MojoExecutionException("Error occurred for following API`s ->\n" + String.join((CharSequence)"\n", this.apiErrors));
        }
        if (!contextOk) {
            throw new MojoExecutionException("Different tags or properties where found ->\n" + String.join((CharSequence)"\n", this.itemsCreator.getContextErrors()));
        }
    }

    private CombineItem processItem(CombineItem item) {
        String url = item.getUrl() == null ? item.getValue() : item.getUrl();
        try {
            this.getLog().info((CharSequence)("Connecting to " + url));
            Map<?, ?> apiInfo = this.getApiInfo((String)(Objects.nonNull(this.infoResourceLocation) ? url + this.infoResourceLocation : url));
            this.itemsCreator.evaluateExpressions(item, apiInfo);
            return item;
        }
        catch (MojoExecutionException ex) {
            this.apiErrors.add(Utils.getItemAsString(item) + " -> not reachable");
            this.getLog().error((CharSequence)("Could not connect to api: " + Utils.getItemAsString(item) + "\n" + ex.getMessage()));
        }
        catch (JsonProcessingException ex) {
            this.apiErrors.add(url + " -> could not parse JSON");
            this.getLog().error((CharSequence)("Could not parse JSON from " + url), (Throwable)ex);
        }
        return null;
    }

    private Map<?, ?> getApiInfo(String url) throws MojoExecutionException, JsonProcessingException {
        String apiResponse = this.apiRequester.getApiResponse(url);
        return (Map)new ObjectMapper().readValue(apiResponse, Map.class);
    }

    private void writeItemsToFile(List<CombineItem> items) {
        String fileName = GENERATED_COMBINE_ITEMS_DIR + File.separator + new File(this.getCombineItemsFile()).getName();
        this.getLog().info((CharSequence)("Created new combine item file -> " + fileName));
        FileUtils.writeStringToFile((File)new File(fileName), (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(items), (Charset)StandardCharsets.UTF_8);
    }

    private void writeUsedGroupsToFile(List<CombineItem> finalListOfItems) {
        Map<String, List<String>> usedGroups = finalListOfItems.stream().map(CombineItem::getGroups).flatMap(Collection::stream).distinct().filter(this.pooler::matchAny).collect(Collectors.toMap(String::toString, e -> finalListOfItems.stream().filter(i -> i.getGroups().contains(e)).map(CombineItem::produceValueUrl).collect(Collectors.toList())));
        List usedItems = finalListOfItems.stream().map(CombineItem::produceValueUrl).collect(Collectors.toList());
        JSONObject result = new JSONObject();
        result.put("usedGroups", usedGroups);
        result.put("excludedGroups", this.excludedGroups);
        result.put("poolGroups", this.poolGroups);
        result.put("usedItems", usedItems);
        File file = new File(USED_GROUPS_PATH);
        FileUtils.writeStringToFile((File)file, (String)result.toString(), (Charset)StandardCharsets.UTF_8);
        System.setProperty("cutest.plugin.groups.usedGroups", this.mapGroupsToString(usedGroups));
        System.setProperty("cutest.plugin.groups.excluded", String.join((CharSequence)",", this.excludedGroups));
        System.setProperty("cutest.plugin.groups.poolGroupString", this.poolGroupsToString());
        System.setProperty("cutest.plugin.groups.usedItems", String.join((CharSequence)",", usedItems));
        this.getLog().info((CharSequence)("Created new used group file -> " + file.getAbsolutePath()));
    }

    private String poolGroupsToString() {
        return String.join((CharSequence)";", this.poolGroups.stream().map(PoolGroup::toPoolGroupString).collect(Collectors.toList()));
    }

    private String mapGroupsToString(Map<String, List<String>> map) {
        StringBuilder sb = new StringBuilder();
        map.forEach((k, v) -> sb.append(" [" + k + "]: " + String.join((CharSequence)" | ", v)));
        return sb.toString();
    }

    private PrepareItemsConfig getCreateItemsConfig() {
        return PrepareItemsConfig.builder().combineItemsFile(this.getCombineItemsFile()).infoResourceLocation(this.infoResourceLocation).tagExpressions(this.tagExpressions).propertyExpressions(this.propertyExpressions).poolGroups(this.poolGroups).excludedGroups(this.excludedGroups).poolSize(this.poolSize).defaultMatchStrategy(this.defaultMatchStrategy).acceptedResponseFamilies(this.getAcceptedResponseFamilies()).allowedResponseCodes(this.getAllowedResponseCodes()).build();
    }

    @Generated
    public void setInfoResourceLocation(String infoResourceLocation) {
        this.infoResourceLocation = infoResourceLocation;
    }

    @Generated
    public void setTagExpressions(List<TagExpression> tagExpressions) {
        this.tagExpressions = tagExpressions;
    }

    @Generated
    public void setPropertyExpressions(List<PropertyExpression> propertyExpressions) {
        this.propertyExpressions = propertyExpressions;
    }

    @Generated
    public void setPoolGroups(List<PoolGroup> poolGroups) {
        this.poolGroups = poolGroups;
    }

    @Generated
    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    @Generated
    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    @Generated
    public void setPoolGroupString(String poolGroupString) {
        this.poolGroupString = poolGroupString;
    }

    @Generated
    public void setDefaultMatchStrategy(GroupMatchStrategyType defaultMatchStrategy) {
        this.defaultMatchStrategy = defaultMatchStrategy;
    }

    @Generated
    public void setSkipPrep(boolean skipPrep) {
        this.skipPrep = skipPrep;
    }

    @Generated
    public void setItemsCreator(ItemsCreator itemsCreator) {
        this.itemsCreator = itemsCreator;
    }

    @Generated
    public void setItems(List<CombineItem> items) {
        this.items = items;
    }

    @Generated
    public void setPooler(Pooler pooler) {
        this.pooler = pooler;
    }

    @Generated
    public void setConfig(PrepareItemsConfig config) {
        this.config = config;
    }

    @Inject
    @Generated
    public PrepareItemsMojo(ApiRequester apiRequester) {
        this.apiRequester = apiRequester;
    }

    @Generated
    public static PrepareItemsMojo getInstance() {
        return instance;
    }

    @Generated
    public static void setInstance(PrepareItemsMojo instance) {
        PrepareItemsMojo.instance = instance;
    }

    @Generated
    public List<PoolGroup> getPoolGroups() {
        return this.poolGroups;
    }

    @Generated
    public GroupMatchStrategyType getDefaultMatchStrategy() {
        return this.defaultMatchStrategy;
    }
}

