/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.execution;

import de.gematik.combine.CombineConfiguration;
import de.gematik.combine.CombineMojo;
import de.gematik.combine.execution.ExamplesProcessor;
import de.gematik.combine.model.CombineItem;
import de.gematik.combine.util.CurrentScenario;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Tag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;

public class ScenarioProcessor {
    public static final Location LOCATION = new Location(Long.valueOf(0L), Long.valueOf(0L));
    private final ExamplesProcessor examplesProcessor;

    public void process(Scenario scenario, CombineConfiguration config, List<CombineItem> combineItems) {
        CurrentScenario.setCurrentScenarioName(scenario.getName());
        List<Examples> examples = scenario.getExamples().stream().filter(example -> ScenarioProcessor.examplesWithoutSkipTag(example, config.getSkipTags())).collect(Collectors.toList());
        CombineMojo.getPluginLog().debug((CharSequence)String.format("processing %d examples: ", examples.size()));
        examples.forEach(table -> this.processExamplesTable((Examples)table, combineItems, config, scenario.getName()));
        this.addEmptyExamplesTags(scenario, config.getEmptyExamplesTags());
        this.checkTableSize(scenario, config.getMinTableSize());
    }

    private void processExamplesTable(Examples examples, List<CombineItem> combineItems, CombineConfiguration configuration, String scenarioName) {
        CombineMojo.getPluginLog().debug((CharSequence)("processing single examples table" + examples.getName()));
        this.examplesProcessor.process(examples, configuration, combineItems, scenarioName);
    }

    private void addEmptyExamplesTags(Scenario scenario, List<String> tags) {
        boolean allExamplesEmpty = scenario.getExamples().stream().allMatch(example -> example.getTableBody().isEmpty());
        if (allExamplesEmpty) {
            this.addTagsToScenario(scenario, tags);
        }
    }

    private void addTagsToScenario(Scenario scenario, List<String> additionalTags) {
        ArrayList tags = new ArrayList(scenario.getTags());
        List mappedAdditionalTags = additionalTags.stream().map(tag -> new Tag(LOCATION, tag, "")).collect(Collectors.toList());
        tags.addAll(mappedAdditionalTags);
        Field field = Scenario.class.getDeclaredField("tags");
        field.setAccessible(true);
        field.set(scenario, tags);
    }

    private static boolean examplesWithoutSkipTag(Examples examples, List<String> skipTags) {
        return examples.getTags().stream().map(tag -> tag.getName().toLowerCase()).noneMatch(skipTags::contains);
    }

    private void checkTableSize(Scenario scenario, int minTableSize) {
        List tableSizes = scenario.getExamples().stream().map(e -> e.getTableBody().size()).filter(e -> e < minTableSize).collect(Collectors.toList());
        if (tableSizes.isEmpty()) {
            return;
        }
        CombineMojo.appendError(String.format("The table of scenario \"%s\" has a table with size %s which is less than the minimal size of %s", scenario.getName(), tableSizes.stream().min(Integer::compareTo).orElse(-1), minTableSize), CombineMojo.ErrorType.SIZE);
    }

    @Inject
    @Generated
    public ScenarioProcessor(ExamplesProcessor examplesProcessor) {
        this.examplesProcessor = examplesProcessor;
    }
}

