/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.execution;

import de.gematik.combine.CombineConfiguration;
import de.gematik.combine.CombineMojo;
import de.gematik.combine.execution.ScenarioProcessor;
import de.gematik.combine.model.CombineItem;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Scenario;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;

public class GherkinProcessor {
    private final ScenarioProcessor scenarioProcessor;

    public void process(GherkinDocument gherkinDocument, CombineConfiguration config, List<CombineItem> combineItems) {
        if (this.fileShouldBeSkipped(gherkinDocument, config.getSkipTags())) {
            return;
        }
        List<Scenario> scenarios = GherkinProcessor.allScenariosInDocument(gherkinDocument, config);
        CombineMojo.getPluginLog().debug((CharSequence)String.format("processing %d scenarios: ", scenarios.size()));
        scenarios.forEach(scenario -> this.scenarioProcessor.process((Scenario)scenario, config, combineItems));
    }

    private boolean fileShouldBeSkipped(GherkinDocument gherkinDocument, List<String> skipTags) {
        if (gherkinDocument.getFeature().isPresent()) {
            return !((Feature)gherkinDocument.getFeature().orElseThrow()).getTags().stream().map(tag -> tag.getName().toLowerCase()).noneMatch(skipTags::contains);
        }
        return false;
    }

    private static List<Scenario> allScenariosInDocument(GherkinDocument document, CombineConfiguration config) {
        return document.getFeature().stream().flatMap(feature -> feature.getChildren().stream()).flatMap(child -> child.getScenario().stream()).filter(scenario -> GherkinProcessor.scenarioWithoutSkipTag(scenario, config.getSkipTags())).collect(Collectors.toList());
    }

    private static boolean scenarioWithoutSkipTag(Scenario scenario, List<String> skipTags) {
        return scenario.getTags().stream().map(tag -> tag.getName().toLowerCase()).noneMatch(skipTags::contains);
    }

    @Inject
    @Generated
    public GherkinProcessor(ScenarioProcessor scenarioProcessor) {
        this.scenarioProcessor = scenarioProcessor;
    }
}

