/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.count;

import de.gematik.BaseMojo;
import de.gematik.combine.CombineConfiguration;
import de.gematik.combine.count.ExampleCounter;
import de.gematik.combine.count.TotalCounter;
import de.gematik.combine.execution.FileProcessor;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Scenario;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ExecutionCounter {
    public static final String COUNT_EXECUTION_FILE_NAME = "countExecution";
    private Set<ExampleCounter> exampleCounter = new TreeSet<ExampleCounter>();

    public void count(CombineConfiguration config) {
        if (!config.isCountExecutions()) {
            return;
        }
        List<File> featureFiles = ExecutionCounter.getFeatureFiles(new File(config.getOutputDir()));
        List<GherkinDocument> features = featureFiles.stream().map(this::transformToGherkin).collect(Collectors.toList());
        this.countExecutions(features);
        this.writeExecutionsToFile(config);
    }

    private static List<File> getFeatureFiles(File file) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f : Objects.requireNonNull(file.listFiles())) {
            if (f.isDirectory()) {
                files.addAll(ExecutionCounter.getFeatureFiles(f));
            }
            files.add(f);
        }
        return files;
    }

    private GherkinDocument transformToGherkin(File f) {
        return FileProcessor.parseGherkinString(Files.readString(f.toPath()));
    }

    private void countExecutions(List<GherkinDocument> features) {
        features.stream().map(GherkinDocument::getFeature).filter(Optional::isPresent).map(Optional::get).forEach(this::countExamples);
    }

    private void countExamples(Feature feature) {
        ExampleCounter counter = new ExampleCounter(feature.getName());
        if (this.exampleCounter.contains(counter)) {
            throw new MojoExecutionException("Could not count features correctly because 2 feature files named the same: " + feature.getName());
        }
        this.exampleCounter.add(counter);
        for (FeatureChild c : feature.getChildren()) {
            c.getScenario().ifPresent(s -> s.getExamples().forEach(e -> counter.addScenario(((Scenario)c.getScenario().get()).getName(), e.getTableBody().size())));
        }
    }

    private void writeExecutionsToFile(CombineConfiguration config) {
        TotalCounter totalCounter = new TotalCounter(this.exampleCounter);
        if (config.getCountExecutionsFormat().contains("json")) {
            this.createJsonFile(totalCounter);
        }
        if (config.getCountExecutionsFormat().contains("txt")) {
            this.createTxtFile(totalCounter);
        }
    }

    private void createJsonFile(TotalCounter totalCounter) {
        ExecutionCounter.writeLineToStatisticFile(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)totalCounter), ".json", true);
    }

    private void createTxtFile(TotalCounter totalCounter) {
        ExecutionCounter.writeLineToStatisticFile("total -> " + totalCounter.getTotal(), ".txt", true);
        ExecutionCounter.writeLineToStatisticFile("totalScenarios -> " + totalCounter.getTotalScenarioAmount(), ".txt", false);
        this.exampleCounter.stream().forEach(e -> {
            this.writeLineToStatisticFile("\n" + e.getName() + " -> " + e.getScenarios().values().stream().reduce(Integer::sum).orElse(0) + " SzenarioAmount => " + e.getScenarioAmount(), ".txt");
            e.getScenarios().forEach((k, v) -> this.writeLineToStatisticFile("\t" + k + " -> " + v, ".txt"));
        });
    }

    private void writeLineToStatisticFile(String s, String fileEnding) {
        ExecutionCounter.writeLineToStatisticFile(s, fileEnding, false);
    }

    private static void writeLineToStatisticFile(String s, String fileEnding, boolean override) {
        FileUtils.write((File)new File(BaseMojo.GENERATED_COMBINE_ITEMS_DIR + File.separator + COUNT_EXECUTION_FILE_NAME + fileEnding), (CharSequence)(s + "\n"), (Charset)StandardCharsets.UTF_8, (!override ? 1 : 0) != 0);
    }
}

