/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.count;

import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ExampleCounter
implements Comparable<ExampleCounter> {
    private String name;
    private Map<String, Integer> scenarios;

    public ExampleCounter(String name) {
        this.name = name;
        this.scenarios = new TreeMap<String, Integer>();
    }

    public Integer getTotal() {
        return this.scenarios.values().stream().reduce(Integer::sum).orElse(0);
    }

    public long getScenarioAmount() {
        return this.scenarios.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).count();
    }

    public void addScenario(String name, int size) {
        this.scenarios.put(name, size);
    }

    @Override
    public int compareTo(@NotNull ExampleCounter exampleCounter) {
        return this.name.compareTo(exampleCounter.name);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Integer> getScenarios() {
        return this.scenarios;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExampleCounter)) {
            return false;
        }
        ExampleCounter other = (ExampleCounter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, Integer> this$scenarios = this.getScenarios();
        Map<String, Integer> other$scenarios = other.getScenarios();
        return !(this$scenarios == null ? other$scenarios != null : !((Object)this$scenarios).equals(other$scenarios));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExampleCounter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, Integer> $scenarios = this.getScenarios();
        result = result * 59 + ($scenarios == null ? 43 : ((Object)$scenarios).hashCode());
        return result;
    }

    @Generated
    public ExampleCounter() {
    }
}

