/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.utils.request;

import de.gematik.utils.Utils;
import de.gematik.utils.request.SSLContextFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ApiRequester {
    private String trustStorePath;
    private String clientCertPath;
    private String trustStorePassword;
    private String clientCertPassword;
    private String proxyHost;
    private Integer proxyPort;
    private OkHttpClient client;
    private List<StatusCodes> allowedFam;
    private List<Integer> allowedCodes;

    public String getApiResponse(String url) throws MojoExecutionException {
        String string;
        block9: {
            if (this.client == null) {
                this.setupAndCreateClient();
            }
            Request request = new Request.Builder().url(url).build();
            Response resp = this.client.newCall(request).execute();
            try {
                this.validateCode(resp.code());
                string = resp.body().string();
                if (resp == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("API did not respond -> " + url + " cause: " + e.getMessage());
                }
            }
            resp.close();
        }
        return string;
    }

    private void validateCode(int code) throws MojoExecutionException {
        if (this.allowedCodes == null) {
            if (this.allowedFam.stream().noneMatch(sc -> sc.isValid(code))) {
                throw new MojoExecutionException("Response code was " + code + " and not in allowed response families" + this.allowedFam);
            }
        } else if (!this.allowedCodes.contains(code)) {
            throw new MojoExecutionException("Response code was " + code + " and not defined in valid response codes " + this.allowedCodes);
        }
    }

    private void setupAndCreateClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.checkAndConfigureProxy(builder);
        this.checkAndConfigureMtls(builder);
        this.client = builder.build();
    }

    private void checkAndConfigureMtls(OkHttpClient.Builder builder) throws MojoExecutionException {
        if (this.sslParameters().noneMatch(Objects::isNull)) {
            SSLContext sslContext = SSLContextFactory.createAndGetSSLContext(this.clientCertPath, this.trustStorePath, this.clientCertPassword, this.trustStorePassword);
            builder.hostnameVerifier((hostname, session) -> true).connectionSpecs(List.of(ConnectionSpec.MODERN_TLS)).sslSocketFactory(sslContext.getSocketFactory(), SSLContextFactory.getX509TrustManager(this.trustStorePath, this.trustStorePassword)).build();
            Utils.getLog().info((CharSequence)"Using mTLS");
        } else if (this.sslParameters().allMatch(Objects::isNull)) {
            Utils.getLog().warn((CharSequence)"Using no TLS");
        } else {
            throw new MojoExecutionException("You tried to set an mTLS context but at least one parameter is missing");
        }
    }

    private void checkAndConfigureProxy(OkHttpClient.Builder builder) throws MojoExecutionException {
        if (this.proxyParameters().noneMatch(Objects::isNull)) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort)));
            Utils.getLog().info((CharSequence)("Using proxy: " + this.proxyHost + ":" + this.proxyPort));
        } else if (this.proxyParameters().allMatch(Objects::isNull)) {
            Utils.getLog().warn((CharSequence)"Using no proxy");
        } else {
            throw new MojoExecutionException("You tried to set a proxy but one parameter is missing");
        }
    }

    public void setAllowedResponses(String fam, String codes) throws MojoExecutionException {
        if (StringUtils.isNotBlank((CharSequence)codes)) {
            try {
                List namedCodes = Arrays.stream(codes.split(",")).map(Integer::valueOf).collect(Collectors.toList());
                if (namedCodes.stream().anyMatch(i -> i >= 600 || i < 100)) {
                    throw new MojoExecutionException("Codes could only have a range of 100 - 599");
                }
                this.allowedCodes = namedCodes;
            }
            catch (NumberFormatException ex) {
                throw new MojoExecutionException("Invalid status code was provided in [" + codes + "]");
            }
        }
        try {
            this.allowedFam = Arrays.asList(fam.split(",")).stream().map(StatusCodes::valueOf).collect(Collectors.toList());
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("Unknown status code family found in \"" + fam + "\" allowed values: " + Arrays.toString((Object[])StatusCodes.values()));
        }
    }

    public void setupProxy(String proxyHost, Integer proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void setupTls(String trustStorePath, String trustStorePassword, String clientCertPath, String clientCertPassword) {
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.clientCertPath = clientCertPath;
        this.clientCertPassword = clientCertPassword;
    }

    private Stream<Object> proxyParameters() {
        return Stream.of(this.proxyHost, this.proxyPort);
    }

    private Stream<Object> sslParameters() {
        return Stream.of(this.trustStorePath, this.trustStorePassword, this.clientCertPath, this.clientCertPassword);
    }

    @Generated
    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public static enum StatusCodes {
        INFO(100, 199),
        SUCCESS(200, 299),
        REDIRECTION(300, 399),
        CLIENT_ERROR(400, 499),
        SERVER_ERROR(500, 599),
        ALL(100, 599);

        final int from;
        final int to;

        private StatusCodes(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public boolean isValid(int code) {
            return code >= this.from && code <= this.to;
        }
    }
}

