/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.prepare.pooling;

import de.gematik.combine.model.CombineItem;
import de.gematik.prepare.PrepareItemsConfig;
import de.gematik.prepare.PrepareItemsMojo;
import de.gematik.prepare.pooling.GroupMatchStrategyType;
import de.gematik.prepare.pooling.GroupMatcher;
import de.gematik.prepare.pooling.PoolGroup;
import de.gematik.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;

public class Pooler {
    private final Random random = new Random();
    private PrepareItemsConfig config;

    public Pooler(PrepareItemsConfig config) {
        this.config = config;
    }

    public List<CombineItem> pool() throws MojoExecutionException {
        List<CombineItem> allCombineItems = Utils.getItemsToCombine(new File(this.config.getCombineItemsFile()), (Mojo)PrepareItemsMojo.getInstance(), false);
        allCombineItems.removeAll(allCombineItems.stream().filter(e -> this.getMatcher(this.config.getExcludedGroups()).order(e.getGroups()).equals("contains")).collect(Collectors.toList()));
        Set<CombineItem> items = this.getNeededItemsFromGroup(allCombineItems);
        if (this.config.getPoolSize() <= 0 && !items.isEmpty()) {
            return new ArrayList<CombineItem>(items);
        }
        allCombineItems.removeAll(items);
        this.doChecks(allCombineItems, items);
        return new ArrayList<CombineItem>(this.fillUpList(allCombineItems, items));
    }

    private Set<CombineItem> getNeededItemsFromGroup(List<CombineItem> allCombineItems) throws MojoExecutionException {
        HashSet<CombineItem> items = new HashSet<CombineItem>();
        for (PoolGroup poolGroup : this.config.getPoolGroups()) {
            items.addAll(this.getRequestedAmountFromPoolGroup(poolGroup, allCombineItems));
        }
        return items;
    }

    private Collection<? extends CombineItem> getRequestedAmountFromPoolGroup(PoolGroup poolGroup, List<CombineItem> allCombineItems) throws MojoExecutionException {
        GroupMatcher matcher = this.getMatcher(poolGroup);
        ArrayList selectedItems = new ArrayList();
        List<CombineItem> matchingItems = matcher.getAllItemsMatching(allCombineItems);
        if (matchingItems.isEmpty()) {
            throw new MojoExecutionException("Could not find at least one match for poolgroup: " + poolGroup);
        }
        List<String> matchingGroups = matcher.getAllMatchingGroups(matchingItems);
        if (matchingGroups.size() < poolGroup.getAmount()) {
            throw new MojoExecutionException(String.format("Requested %s for group(s) %s but only found %s matching group(s) (%s) with matching strategy %s", new Object[]{poolGroup.getAmount(), poolGroup.getGroupPattern(), matchingGroups.size(), matchingGroups, poolGroup.getStrategy()}));
        }
        if (poolGroup.getAmount() < 1) {
            return allCombineItems.stream().filter(item -> matcher.order((CombineItem)item).equals("contains")).collect(Collectors.toSet());
        }
        IntStream.range(0, poolGroup.getAmount()).forEach(i -> {
            String randomGroup = this.selectRandomGroup(matchingItems, matcher);
            List randomSelectedItems = matchingItems.stream().filter(item -> item.getGroups().contains(randomGroup)).collect(Collectors.toList());
            matchingItems.removeAll(randomSelectedItems);
            selectedItems.addAll(randomSelectedItems);
        });
        return selectedItems;
    }

    private String selectRandomGroup(List<CombineItem> matchingItems, GroupMatcher matcher) {
        List<String> validGroups = matcher.getAllMatchingGroups(matchingItems);
        return validGroups.get(this.random.nextInt(validGroups.size()));
    }

    private Set<CombineItem> fillUpList(List<CombineItem> leftItems, Set<CombineItem> items) {
        if (this.config.getPoolSize() < 1) {
            return new HashSet<CombineItem>(leftItems);
        }
        while (this.countGroups(items) < (long)this.config.getPoolSize() || items.size() < this.config.getPoolSize()) {
            CombineItem randomItem = leftItems.get(this.random.nextInt(leftItems.size()));
            if (randomItem.getGroups().isEmpty()) {
                items.add(randomItem);
                leftItems.remove(randomItem);
                continue;
            }
            String randomGroup = new ArrayList<String>(randomItem.getGroups()).get(this.random.nextInt(randomItem.getGroups().size()));
            List newItems = leftItems.stream().filter(i -> this.getMatcher(List.of(randomGroup)).order((CombineItem)i).equals("contains")).collect(Collectors.toList());
            items.addAll(newItems);
            leftItems.removeAll(newItems);
        }
        return items;
    }

    private void doChecks(List<CombineItem> leftItems, Set<CombineItem> items) throws MojoExecutionException {
        if (this.countGroups(leftItems) + this.countGroups(items) < (long)this.config.getPoolSize()) {
            throw new MojoExecutionException("PoolSize to high! Could not find sufficient item-groups to fulfill request");
        }
    }

    private long countGroups(Collection<CombineItem> itemList) {
        long itemsWithoutGroup = itemList.stream().filter(i -> i.getGroups().isEmpty()).count();
        long sumGroupsFromItems = itemList.stream().map(CombineItem::getGroups).flatMap(Collection::stream).collect(Collectors.toSet()).size();
        return sumGroupsFromItems + itemsWithoutGroup;
    }

    private GroupMatcher getMatcher(PoolGroup poolGroup) {
        return poolGroup.getStrategy() == null ? this.getMatcher(poolGroup.getGroupPattern()) : this.getMatcher(poolGroup.getStrategy(), poolGroup.getGroupPattern());
    }

    private GroupMatcher getMatcher(List<String> groups) {
        return this.getMatcher(this.config.getDefaultMatchStrategy(), groups);
    }

    private GroupMatcher getMatcher(GroupMatchStrategyType strategy, List<String> groups) {
        return new GroupMatcher(groups, strategy);
    }

    @Generated
    public Pooler() {
    }

    @Generated
    public void setConfig(PrepareItemsConfig config) {
        this.config = config;
    }
}

