/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.execution;

import de.gematik.combine.CombineConfiguration;
import de.gematik.combine.CombineMojo;
import de.gematik.combine.FilterTagMapper;
import de.gematik.combine.execution.TableGenerator;
import de.gematik.combine.filter.project.ProjectCellFilter;
import de.gematik.combine.filter.project.ProjectRowFilter;
import de.gematik.combine.filter.table.TableFilter;
import de.gematik.combine.filter.table.cell.VersionFilter;
import de.gematik.combine.model.CombineItem;
import de.gematik.combine.tags.ConfiguredFilters;
import de.gematik.combine.tags.ParsedTags;
import de.gematik.combine.tags.TagParser;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;

public class ExamplesProcessor {
    private static final Location LOCATION = new Location(Long.valueOf(0L), Long.valueOf(0L));
    private final TagParser tagParser;
    private final TableGenerator tableGenerator;

    public void process(Examples gherkinExample, CombineConfiguration config, List<CombineItem> combineItems, String scenarioName) {
        boolean tableToSmall;
        if (!config.getDefaultExamplesTags().isEmpty()) {
            ExamplesProcessor.addDefaultTags(gherkinExample, config.getDefaultExamplesTags());
        }
        List<String> headers = ExamplesProcessor.extractHeaders(gherkinExample);
        List<String> tagStrings = ExamplesProcessor.extractTagStrings(gherkinExample);
        ParsedTags parsedTags = this.tagParser.parseTags(tagStrings, headers);
        this.generateTable(gherkinExample, config, combineItems, parsedTags, true);
        boolean bl = tableToSmall = gherkinExample.getTableBody().size() < config.getMinTableSize();
        if (tableToSmall && !config.isSoftFilterToHardFilter() && parsedTags.containSoftFilter()) {
            CombineMojo.appendError(String.format("For scenario \"%s\" no table could be generated. Going to retry without SoftFilter", scenarioName), CombineMojo.ErrorType.WARNING);
            this.generateTable(gherkinExample, config, combineItems, parsedTags, false);
        }
        ExamplesProcessor.addPluginTagPrefixes(gherkinExample, config);
    }

    private void generateTable(Examples gherkinExample, CombineConfiguration config, List<CombineItem> combineItems, ParsedTags parsedTags, boolean softFilterShouldApply) {
        ConfiguredFilters filters = parsedTags.configureFilters(config, softFilterShouldApply);
        List<List<de.gematik.combine.model.TableCell>> filteredTable = this.generateTable(combineItems, filters);
        CombineMojo.getPluginLog().debug((CharSequence)"converting table to gherkin format");
        List<TableRow> gherkinTable = filteredTable.stream().map(ExamplesProcessor::toTableRow).collect(Collectors.toList());
        ExamplesProcessor.setTableBody(gherkinExample, gherkinTable);
        ExamplesProcessor.addAppliedProjectFilters(gherkinExample, filters);
    }

    private List<List<de.gematik.combine.model.TableCell>> generateTable(List<CombineItem> combineItems, ConfiguredFilters filters) {
        List<List<de.gematik.combine.model.TableCell>> baseTable = this.generateBaseTable(combineItems, filters);
        return this.filterTable(baseTable, filters);
    }

    private List<List<de.gematik.combine.model.TableCell>> filterTable(List<List<de.gematik.combine.model.TableCell>> baseTable, ConfiguredFilters filters) {
        ArrayList<TableFilter> tableFilters = new ArrayList<TableFilter>(filters.getTableFilters());
        tableFilters.addAll(filters.getTableRowFilters());
        CombineMojo.getPluginLog().debug((CharSequence)String.format("applying %d filters: %s", tableFilters.size(), tableFilters));
        return filters.combineAllFilters().apply(baseTable);
    }

    private List<List<de.gematik.combine.model.TableCell>> generateBaseTable(List<CombineItem> combineItems, ConfiguredFilters filters) {
        return this.tableGenerator.generateTable(combineItems, filters);
    }

    private static void setTableBody(Examples examples, List<TableRow> table) {
        Field field = Examples.class.getDeclaredField("tableBody");
        field.setAccessible(true);
        field.set(examples, table);
    }

    private static void addDefaultTags(Examples examples, List<String> defaultTags) {
        ArrayList<Tag> tags = new ArrayList<Tag>(examples.getTags());
        tags.addAll(defaultTags.stream().map(tagStr -> new Tag(LOCATION, tagStr, tagStr)).collect(Collectors.toList()));
        ExamplesProcessor.setTags(examples, tags);
    }

    private static void addAppliedProjectFilters(Examples examples, ConfiguredFilters filters) {
        ArrayList<Tag> tags = new ArrayList<Tag>(examples.getTags());
        tags.addAll(ExamplesProcessor.getAppliedProjectCellFilters(filters));
        tags.addAll(ExamplesProcessor.getAppliedProjectTableRowFilters(filters));
        ExamplesProcessor.setTags(examples, tags);
    }

    private static void addPluginTagPrefixes(Examples examples, CombineConfiguration config) {
        List<Tag> changedTags = examples.getTags().stream().map(tag -> ExamplesProcessor.addPrefixToTag(tag, tag.getName().substring(1).startsWith(FilterTagMapper.getTagName(VersionFilter.class), 0) ? config.getVersionFilterTagCategory() : config.getPluginTagCategory())).collect(Collectors.toList());
        ExamplesProcessor.setTags(examples, changedTags);
    }

    private static void setTags(Examples examples, List<Tag> tags) {
        Field field = Examples.class.getDeclaredField("tags");
        field.setAccessible(true);
        field.set(examples, tags);
    }

    private static TableRow toTableRow(List<de.gematik.combine.model.TableCell> row) {
        List cells = row.stream().map(value -> new TableCell(LOCATION, value.getValue())).collect(Collectors.toList());
        return new TableRow(LOCATION, cells, UUID.randomUUID().toString());
    }

    private static List<String> extractHeaders(Examples examples) {
        return ((TableRow)examples.getTableHeader().orElseThrow()).getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
    }

    private static List<String> extractTagStrings(Examples examples) {
        return examples.getTags().stream().map(Tag::getName).collect(Collectors.toList());
    }

    private static List<Tag> getAppliedProjectTableRowFilters(ConfiguredFilters filters) {
        return filters.getTableRowFilters().stream().filter(ProjectRowFilter.class::isInstance).map(filter -> ExamplesProcessor.getProjectRowFilterTag((ProjectRowFilter)filter)).collect(Collectors.toList());
    }

    private static List<Tag> getAppliedProjectCellFilters(ConfiguredFilters filters) {
        return filters.getCellFilters().entrySet().stream().map(column -> new AbstractMap.SimpleEntry((String)column.getKey(), ((List)column.getValue()).stream().filter(ProjectCellFilter.class::isInstance).map(filter -> ExamplesProcessor.getProjectCellFilterTag((String)column.getKey(), (ProjectCellFilter)filter)).collect(Collectors.toList()))).flatMap(column -> ((List)column.getValue()).stream()).collect(Collectors.toList());
    }

    private static Tag getProjectRowFilterTag(ProjectRowFilter filter) {
        return FilterTagMapper.filterToTag(filter.toString(), filter);
    }

    private static Tag getProjectCellFilterTag(String key, ProjectCellFilter filter) {
        return FilterTagMapper.filterToTag(key + filter.toString(), filter);
    }

    private static Tag addPrefixToTag(Tag tag, String prefix) {
        String newTagStr = String.format("@%s:%s", prefix, tag.getName().substring(1));
        return new Tag(LOCATION, newTagStr, tag.getId());
    }

    @Inject
    @Generated
    public ExamplesProcessor(TagParser tagParser, TableGenerator tableGenerator) {
        this.tagParser = tagParser;
        this.tableGenerator = tableGenerator;
    }
}

