/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine;

import de.gematik.combine.filter.project.ProjectVersionFilter;
import de.gematik.combine.filter.table.DistinctColumnFilter;
import de.gematik.combine.filter.table.DoubleLineupFilter;
import de.gematik.combine.filter.table.MaxRowsFilter;
import de.gematik.combine.filter.table.MaxSameColumnPropertyFilter;
import de.gematik.combine.filter.table.ShuffleTableFilter;
import de.gematik.combine.filter.table.cell.JexlCellFilter;
import de.gematik.combine.filter.table.cell.VersionFilter;
import de.gematik.combine.filter.table.row.DistinctRowPropertyFilter;
import de.gematik.combine.filter.table.row.EqualRowPropertyFilter;
import de.gematik.combine.filter.table.row.JexlRowFilter;
import de.gematik.combine.filter.table.row.RequireTagRowFilter;
import de.gematik.combine.filter.table.row.SelfCombineFilter;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Tag;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public final class FilterTagMapper {
    private static final Map<Class<?>, String> MAP = new HashMap();

    private FilterTagMapper() {
    }

    @NonNull
    public static String getTagName(Class<?> clazz) {
        return MAP.get(clazz);
    }

    public static Tag filterToTag(String value, Object caller) {
        String s = String.format("@%s(%s)", caller instanceof String ? caller : FilterTagMapper.getTagName(caller.getClass()), value);
        return new Tag(new Location(Long.valueOf(0L), Long.valueOf(0L)), s, s);
    }

    static {
        MAP.put(JexlCellFilter.class, "Filter");
        MAP.put(JexlRowFilter.class, "Filter");
        MAP.put(VersionFilter.class, "Version");
        MAP.put(ProjectVersionFilter.class, "Version");
        MAP.put(DistinctRowPropertyFilter.class, "DistinctProperty");
        MAP.put(EqualRowPropertyFilter.class, "EqualProperty");
        MAP.put(RequireTagRowFilter.class, "RequireTag");
        MAP.put(SelfCombineFilter.class, "AllowSelfCombine");
        MAP.put(DistinctColumnFilter.class, "DistinctColumn");
        MAP.put(DoubleLineupFilter.class, "AllowDoubleLineup");
        MAP.put(MaxRowsFilter.class, "MaxRows");
        MAP.put(MaxSameColumnPropertyFilter.class, "MaxSameColumnProperty");
        MAP.put(ShuffleTableFilter.class, "Shuffle");
    }
}

