/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.prepare.pooling.strategies;

import de.gematik.prepare.pooling.strategies.MatchStrategy;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class WildcardStrategy
extends MatchStrategy {
    public WildcardStrategy(List<String> groups) {
        super(groups.stream().map(String::toLowerCase).collect(Collectors.toList()));
    }

    @Override
    protected boolean doesMatch(String group) {
        return this.pattern.stream().anyMatch(e -> this.match((String)e, group));
    }

    private boolean match(String group, String itemGroup) {
        itemGroup = itemGroup.toLowerCase();
        List parts = List.of(group.split("\\*")).stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (!group.startsWith("*") && !itemGroup.startsWith((String)parts.get(0))) {
            return false;
        }
        if (!group.endsWith("*") && !itemGroup.endsWith((String)parts.get(parts.size() - 1))) {
            return false;
        }
        for (String p : parts) {
            if (itemGroup.contains(p)) {
                itemGroup = itemGroup.replaceFirst(p, "");
                continue;
            }
            return false;
        }
        return true;
    }
}

