/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.tags.parser;

import de.gematik.combine.filter.table.MaxRowsFilter;
import de.gematik.combine.tags.ParsedTags;
import de.gematik.combine.tags.SingleTagParser;
import de.gematik.combine.tags.TagParser;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.math.NumberUtils;

@Named(value="MaxRows")
@Singleton
public class MaxRowsTagParser
implements SingleTagParser {
    public static final String MAX_ROWS_TAG = "MaxRows";

    @Override
    public void parseTagAndRegister(TagParser.PreParsedTag preParsedTag, ParsedTags parsedTags) {
        if (NumberUtils.isDigits((String)preParsedTag.getValue()) && NumberUtils.isParsable((String)preParsedTag.getValue())) {
            int maxRows = Integer.parseInt(preParsedTag.getValue());
            parsedTags.addConfigModifier(config -> config.toBuilder().maxTableRows(maxRows).build());
        } else {
            parsedTags.addTableFilter(new MaxRowsFilter(preParsedTag.getValue()).setSoft(preParsedTag.isSoft()));
        }
    }
}

