/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter.table;

import de.gematik.combine.CombineMojo;
import de.gematik.combine.filter.table.AbstractTableFilter;
import de.gematik.combine.model.TableCell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;

public class MaxSameColumnPropertyFilter
extends AbstractTableFilter {
    private final String columnName;
    private final String property;
    private final int maxCount;

    @Override
    public List<List<TableCell>> apply(List<List<TableCell>> table) {
        CombineMojo.getPluginLog().debug((CharSequence)String.format("applying %s on %d rows", this, table.size()));
        HashMap propCounts = new HashMap();
        return table.stream().filter(row -> this.checkRow((List<TableCell>)row, propCounts)).collect(Collectors.toList());
    }

    private boolean checkRow(List<TableCell> row, Map<String, AtomicInteger> propCounts) {
        Optional<TableCell> cell = row.stream().filter(tv -> tv.getHeader().equals(this.columnName)).findAny();
        Optional<String> propValue = cell.map(tv -> tv.getProperties().get(this.property));
        if (propValue.isPresent() && !propCounts.containsKey(propValue.get())) {
            propCounts.put(propValue.get(), new AtomicInteger());
        }
        return propValue.map(propCounts::get).map(AtomicInteger::incrementAndGet).map(count -> count <= this.maxCount).orElse(true);
    }

    @Generated
    public String toString() {
        return "MaxSameColumnPropertyFilter(columnName=" + this.columnName + ", property=" + this.property + ", maxCount=" + this.maxCount + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxSameColumnPropertyFilter)) {
            return false;
        }
        MaxSameColumnPropertyFilter other = (MaxSameColumnPropertyFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxCount != other.maxCount) {
            return false;
        }
        String this$columnName = this.columnName;
        String other$columnName = other.columnName;
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$property = this.property;
        String other$property = other.property;
        return !(this$property == null ? other$property != null : !this$property.equals(other$property));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MaxSameColumnPropertyFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxCount;
        String $columnName = this.columnName;
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $property = this.property;
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        return result;
    }

    @Generated
    public MaxSameColumnPropertyFilter(String columnName, String property, int maxCount) {
        this.columnName = columnName;
        this.property = property;
        this.maxCount = maxCount;
    }
}

