/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter.jexl;

import de.gematik.combine.filter.jexl.JexlContextVariables;
import de.gematik.combine.filter.jexl.JexlFilterColumn;
import de.gematik.combine.model.TableCell;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.MapContext;
import org.apache.maven.plugin.MojoExecutionException;

public class JexlFilter {
    public static final JexlEngine JEXL_ENGINE = new JexlBuilder().strict(true).silent(false).safe(false).create();
    private final JexlExpression expression;
    private final JexlContext context = new MapContext();

    public JexlFilter(String filterExpression) {
        this.expression = JEXL_ENGINE.createExpression(filterExpression);
    }

    public <T> T evaluate() {
        return this.evaluate(this.context);
    }

    public <T> void addToContext(String key, T value) {
        this.context.set(key, value);
    }

    public void addToContext(JexlFilterColumn jexlFilterColumn) {
        this.addToContext(jexlFilterColumn.getHeader(), jexlFilterColumn);
    }

    public void addToContext(TableCell tableCell) {
        this.addToContext(tableCell.getHeader(), tableCell.getCombineItem());
    }

    public void addToContext(List<TableCell> tableRow) {
        tableRow.forEach(this::addToContext);
        tableRow.forEach(cell -> {
            this.addTags(cell.getTags());
            this.addProperties(cell.getProperties());
        });
        this.addToContext(JexlContextVariables.COLUMN_COUNT.key, tableRow.size());
    }

    public void addTableInfoToContext(List<List<TableCell>> table) {
        this.addToContext(JexlContextVariables.ROW_COUNT.key, table.size());
        if (table.isEmpty()) {
            return;
        }
        this.addToContext(JexlContextVariables.COLUMN_COUNT.key, table.get(0).size());
        List<JexlFilterColumn> columns = this.toColumns(table);
        for (JexlFilterColumn col : columns) {
            this.addToContext(col);
        }
    }

    private void addTags(Set<String> tags) {
        HashMap allTags = (HashMap)this.context.get(JexlContextVariables.ALL_TAGS.key);
        if (allTags == null) {
            allTags = new HashMap();
            this.context.set(JexlContextVariables.ALL_TAGS.key, allTags);
        }
        HashMap finalAllTags = allTags;
        tags.forEach(tag -> finalAllTags.put(tag, finalAllTags.getOrDefault(tag, 0) + 1));
    }

    private void addProperties(Map<String, String> properties) {
        HashMap allProps = (HashMap)this.context.get(JexlContextVariables.ALL_PROPERTIES.key);
        if (allProps == null) {
            allProps = new HashMap();
            this.context.set(JexlContextVariables.ALL_PROPERTIES.key, allProps);
        }
        HashMap finalAllProps = allProps;
        properties.forEach((key, value) -> {
            if (!finalAllProps.containsKey(key)) {
                finalAllProps.put(key, new HashSet());
            }
            ((Set)finalAllProps.get(key)).add(value);
        });
    }

    private List<JexlFilterColumn> toColumns(List<List<TableCell>> table) {
        Map<String, List<TableCell>> columns = table.stream().flatMap(Collection::stream).collect(Collectors.groupingBy(TableCell::getHeader));
        return columns.entrySet().stream().map(kv -> new JexlFilterColumn((String)kv.getKey(), (List)kv.getValue())).collect(Collectors.toList());
    }

    private <T> T evaluate(JexlContext context) {
        try {
            return (T)this.expression.evaluate(context);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not evaluate expression '%s': %s", this.expression.getSourceText(), e.getMessage()), e);
        }
    }

    public String toString() {
        return this.expression.getSourceText();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JexlFilter)) {
            return false;
        }
        JexlFilter other = (JexlFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JexlExpression this$expression = this.expression;
        JexlExpression other$expression = other.expression;
        return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JexlFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JexlExpression $expression = this.expression;
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        return result;
    }
}

