/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.utils.request;

import de.gematik.utils.Utils;
import de.gematik.utils.request.SSLContextFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.apache.maven.plugin.MojoExecutionException;

public class ApiRequester {
    private String trustStorePath;
    private String clientCertPath;
    private String trustStorePassword;
    private String clientCertPassword;
    private String proxyHost;
    private Integer proxyPort;
    private OkHttpClient client;

    public String getApiResponse(String url) throws MojoExecutionException {
        String string;
        block9: {
            if (this.client == null) {
                this.setupAndCreateClient();
            }
            Request request = new Request.Builder().url(url).build();
            ResponseBody body = this.client.newCall(request).execute().body();
            try {
                string = body.string();
                if (body == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("API did not respond -> " + url + " cause: " + e.getMessage());
                }
            }
            body.close();
        }
        return string;
    }

    private void setupAndCreateClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.checkAndConfigureProxy(builder);
        this.checkAndConfigureMtls(builder);
        this.client = builder.build();
    }

    private void checkAndConfigureMtls(OkHttpClient.Builder builder) throws MojoExecutionException {
        if (this.sslParameters().noneMatch(Objects::isNull)) {
            SSLContext sslContext = SSLContextFactory.createAndGetSSLContext(this.clientCertPath, this.trustStorePath, this.clientCertPassword, this.trustStorePassword);
            builder.hostnameVerifier((hostname, session) -> true).connectionSpecs(List.of(ConnectionSpec.MODERN_TLS)).sslSocketFactory(sslContext.getSocketFactory(), SSLContextFactory.getX509TrustManager(this.trustStorePath, this.trustStorePassword)).build();
            Utils.getLog().info((CharSequence)"Using mTLS");
        } else if (this.sslParameters().allMatch(Objects::isNull)) {
            Utils.getLog().warn((CharSequence)"Using no TLS");
        } else {
            throw new MojoExecutionException("You tried to set an mTLS context but at least one parameter is missing");
        }
    }

    private void checkAndConfigureProxy(OkHttpClient.Builder builder) throws MojoExecutionException {
        if (this.proxyParameters().noneMatch(Objects::isNull)) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, (int)this.proxyPort)));
            Utils.getLog().info((CharSequence)("Using proxy: " + this.proxyHost + ":" + this.proxyPort));
        } else if (this.proxyParameters().allMatch(Objects::isNull)) {
            Utils.getLog().warn((CharSequence)"Using no proxy");
        } else {
            throw new MojoExecutionException("You tried to set a proxy but one parameter is missing");
        }
    }

    public void setupProxy(String proxyHost, Integer proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void setupTls(String trustStorePath, String trustStorePassword, String clientCertPath, String clientCertPassword) {
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.clientCertPath = clientCertPath;
        this.clientCertPassword = clientCertPassword;
    }

    private Stream<Object> proxyParameters() {
        return Stream.of(this.proxyHost, this.proxyPort);
    }

    private Stream<Object> sslParameters() {
        return Stream.of(this.trustStorePath, this.trustStorePassword, this.clientCertPath, this.clientCertPassword);
    }
}

