/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.prepare.pooling;

import de.gematik.combine.model.CombineItem;
import de.gematik.prepare.pooling.GroupMatchStrategyType;
import de.gematik.prepare.pooling.strategies.CaseInsensitiveExactStrategy;
import de.gematik.prepare.pooling.strategies.CaseInsensitiveStrategy;
import de.gematik.prepare.pooling.strategies.CaseSensitiveExactStrategy;
import de.gematik.prepare.pooling.strategies.CaseSensitiveStrategy;
import de.gematik.prepare.pooling.strategies.MatchStrategy;
import de.gematik.prepare.pooling.strategies.RegexStrategy;
import de.gematik.prepare.pooling.strategies.WildcardStrategy;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class GroupMatcher {
    private List<String> groups;
    private GroupMatchStrategyType strategyType;

    public String order(CombineItem combineItem) {
        return this.order(combineItem.getGroups());
    }

    public String order(Set<String> groups) {
        return this.getStrategy().match(groups);
    }

    public List<String> getAllMatchingGroups(List<CombineItem> matchingItems) {
        return this.getAllMatchingGroups(matchingItems.stream().map(CombineItem::getGroups).flatMap(Collection::stream).collect(Collectors.toSet()));
    }

    public List<String> getAllMatchingGroups(Set<String> groups) {
        MatchStrategy strategy = this.getStrategy();
        return groups.stream().filter(e -> strategy.match(Set.of(e)).equals("contains")).collect(Collectors.toList());
    }

    public List<CombineItem> getAllItemsMatching(List<CombineItem> allItems) {
        return allItems.stream().filter(item -> this.order((CombineItem)item).equals("contains")).collect(Collectors.toList());
    }

    private MatchStrategy getStrategy() {
        switch (this.strategyType) {
            case CASE_INSENSITIVE: {
                return new CaseInsensitiveStrategy(this.groups);
            }
            case CASE_INSENSITIVE_EXACT: {
                return new CaseInsensitiveExactStrategy(this.groups);
            }
            case CASE_SENSITIVE: {
                return new CaseSensitiveStrategy(this.groups);
            }
            case CASE_SENSITIVE_EXACT: {
                return new CaseSensitiveExactStrategy(this.groups);
            }
            case REGEX: {
                return new RegexStrategy(this.groups);
            }
        }
        return new WildcardStrategy(this.groups);
    }

    @Generated
    public GroupMatcher(List<String> groups, GroupMatchStrategyType strategyType) {
        this.groups = groups;
        this.strategyType = strategyType;
    }
}

