/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.tags.parser;

import de.gematik.combine.filter.project.ProjectCellFilter;
import de.gematik.combine.filter.project.ProjectVersionFilter;
import de.gematik.combine.filter.table.cell.VersionFilter;
import de.gematik.combine.model.properties.Version;
import de.gematik.combine.tags.ParsedTags;
import de.gematik.combine.tags.SingleTagParser;
import de.gematik.combine.tags.TagParser;
import de.gematik.combine.util.CompareOperator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="Version")
@Singleton
public class VersionFilterParser
implements SingleTagParser {
    public static final String VERSION_TAG = "Version";

    public static ProjectCellFilter parseProjectFilter(String val) {
        VersionFilter filter = VersionFilterParser.parseFilterValue(val);
        return new ProjectVersionFilter(filter.getOperator(), filter.getFilterVersion());
    }

    @Override
    public void parseTagAndRegister(TagParser.PreParsedTag preParsedTag, ParsedTags parsedTags) {
        VersionFilter filter = VersionFilterParser.parseFilterValue(preParsedTag.getValue());
        filter.setSoft(preParsedTag.isSoft());
        List<String> args = VersionFilterParser.checkForOperator(preParsedTag.getValue(), filter.getOperator());
        String[] columns = args.get(0).split(",");
        if (columns.length == 0 || columns.length == 1 && columns[0].isBlank()) {
            throw new IllegalArgumentException(String.format("%s: '%s' does not have any headers, which are necessary for a version filter that is set to a scenario", VERSION_TAG, preParsedTag.getValue()));
        }
        for (String header : columns) {
            parsedTags.addCellFilter(header, filter);
        }
    }

    private static List<String> checkForOperator(String tagVal, CompareOperator op) {
        return Arrays.stream(VersionFilterParser.checkForOperatorName(tagVal, op)).flatMap(s -> Arrays.stream(VersionFilterParser.checkForOperatorLiteral(s, op))).collect(Collectors.toList());
    }

    private static String[] checkForOperatorName(String tagVal, CompareOperator op) {
        return tagVal.trim().split(String.format("--%s--", op.name()));
    }

    private static String[] checkForOperatorLiteral(String tagVal, CompareOperator op) {
        return tagVal.trim().split(op.getLiteral());
    }

    private static VersionFilter getVersionFilter(CompareOperator op, String version) {
        return new VersionFilter(op, Version.getSemanticVersion(version));
    }

    private static VersionFilter parseFilterValue(String val) {
        for (CompareOperator op : CompareOperator.values()) {
            List<String> args = VersionFilterParser.checkForOperator(val, op);
            if (args.size() == 1) continue;
            if (args.size() != 2) {
                throw new IllegalArgumentException(String.format("%s: '%s' does not have the right number of arguments", VERSION_TAG, val));
            }
            return VersionFilterParser.getVersionFilter(op, args.get(1));
        }
        throw new IllegalArgumentException(String.format("A version filter must contain a comparison operator: %s", CompareOperator.getUsableOperators()));
    }
}

