/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.tags.parser;

import de.gematik.combine.filter.table.row.RequirePropertyRowFilter;
import de.gematik.combine.filter.table.row.TableRowFilter;
import de.gematik.combine.tags.ParsedTags;
import de.gematik.combine.tags.SingleTagParser;
import de.gematik.combine.tags.TagParser;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="RequireProperty")
@Singleton
public class RequirePropertyTagParser
implements SingleTagParser {
    public static final String REQUIRE_PROPERTY_TAG = "RequireProperty";

    @Override
    public void parseTagAndRegister(TagParser.PreParsedTag preParsedTag, ParsedTags parsedTags) {
        String[] args = preParsedTag.getValue().split(",");
        if (args.length != 2) {
            throw new IllegalArgumentException("RequireProperty: '" + preParsedTag.getValue() + "' does not have exact 2 arguments");
        }
        parsedTags.addTableRowFilter((TableRowFilter)new RequirePropertyRowFilter(args[0], args[1]).setSoft(preParsedTag.isSoft()));
    }
}

