/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.tags.parser;

import de.gematik.combine.filter.table.cell.JexlCellFilter;
import de.gematik.combine.filter.table.row.JexlRowFilter;
import de.gematik.combine.tags.ParsedTags;
import de.gematik.combine.tags.SingleTagParser;
import de.gematik.combine.tags.TagParser;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="Filter")
@Singleton
public class FilterTagParser
implements SingleTagParser {
    public static final String JEXL_ROW_FILTER_TAG = "Filter";

    @Override
    public void parseTagAndRegister(TagParser.PreParsedTag preParsedTag, ParsedTags parsedTags) {
        List<String> columnReferences = this.countColumnReferences(preParsedTag.getValue(), parsedTags.getColumns());
        if (columnReferences.size() == 1) {
            String column = columnReferences.get(0);
            JexlCellFilter filter = new JexlCellFilter(column, preParsedTag.getValue());
            filter.setSoft(preParsedTag.isSoft());
            parsedTags.addCellFilter(column, filter);
        } else {
            JexlRowFilter filter = new JexlRowFilter(preParsedTag.getValue());
            filter.setSoft(preParsedTag.isSoft());
            parsedTags.addTableRowFilter(filter);
        }
    }

    private List<String> countColumnReferences(String expression, List<String> columns) {
        return columns.stream().filter(expression::contains).collect(Collectors.toList());
    }
}

