/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter.table;

import de.gematik.combine.CombineMojo;
import de.gematik.combine.filter.FilterOrder;
import de.gematik.combine.filter.jexl.JexlFilter;
import de.gematik.combine.filter.table.AbstractTableFilter;
import de.gematik.combine.model.TableCell;
import java.util.List;
import lombok.Generated;

public class MaxRowsFilter
extends AbstractTableFilter {
    private final JexlFilter jexlFilter;

    public MaxRowsFilter(String filterExpression) {
        this.jexlFilter = new JexlFilter(filterExpression);
    }

    @Override
    public List<List<TableCell>> apply(List<List<TableCell>> table) {
        this.jexlFilter.addTableInfoToContext(table);
        int maxRows = (Integer)this.jexlFilter.evaluate();
        CombineMojo.getPluginLog().debug((CharSequence)String.format("applying %s on %d rows", this, table.size()));
        return table.subList(0, Math.min(table.size(), maxRows));
    }

    @Override
    public FilterOrder getFilterOrder() {
        return FilterOrder.MAX_ROWS;
    }

    public String toString() {
        return "MaxRowsFilter(\"" + this.jexlFilter + "\")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxRowsFilter)) {
            return false;
        }
        MaxRowsFilter other = (MaxRowsFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JexlFilter this$jexlFilter = this.jexlFilter;
        JexlFilter other$jexlFilter = other.jexlFilter;
        return !(this$jexlFilter == null ? other$jexlFilter != null : !((Object)this$jexlFilter).equals(other$jexlFilter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MaxRowsFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JexlFilter $jexlFilter = this.jexlFilter;
        result = result * 59 + ($jexlFilter == null ? 43 : ((Object)$jexlFilter).hashCode());
        return result;
    }
}

