/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine;

import de.gematik.BaseMojo;
import de.gematik.combine.CombineConfiguration;
import de.gematik.combine.FilterConfiguration;
import de.gematik.combine.ProjectFilters;
import de.gematik.combine.execution.FileProcessor;
import de.gematik.combine.model.CombineItem;
import de.gematik.utils.Utils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;

@org.apache.maven.plugins.annotations.Mojo(name="prepare-combine", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class CombineMojo
extends BaseMojo {
    public static final String EMPTY_EXAMPLES_TABLE_TAG = "@EMPTY_EXAMPLES_TABLE";
    public static final String WIP_TAG = "@WIP";
    public static final String TEST_RESOURCES_DIR = "./src/test/resources/";
    public static final String WARN_MESSAGE = "=== Caution!!! The feature file which is prepared have some issues and may not contain the expected value ===";
    public static final String MINIMAL_TABLE_ERROR_HEADER = "Minimal table should be created and failed. For following apis a valid row could not be generated:\n\t";
    private static CombineMojo instance;
    private static List<String> tableSizeErrorLog;
    private static List<String> minimalTableErrorLog;
    private static List<String> propertyErrorLog;
    private static List<String> warningsLog;
    private final FileProcessor replacer;
    @Parameter(property="outputDir", defaultValue="./src/test/resources/features")
    String outputDir;
    @Parameter(property="templateDir", defaultValue="./src/test/resources/templates")
    String templateDir;
    @Parameter(property="ending", defaultValue=".cute")
    String ending;
    @Parameter(property="emptyExamplesTags")
    List<String> emptyExamplesTags;
    @Parameter(property="breakIfTableToSmall", defaultValue="true")
    boolean breakIfTableToSmall;
    @Parameter(property="minTableSize", defaultValue="1")
    int minTableSize;
    @Parameter(property="breakIfMinimalTableError", defaultValue="false")
    boolean breakIfMinimalTableError;
    @Parameter(property="pluginTagCategory", defaultValue="Plugin")
    String pluginTagCategory;
    @Parameter(property="versionFilterTagCategory", defaultValue="VersionFilter")
    String versionFilterTagCategory;
    @Parameter(property="versionProperty", defaultValue="version")
    String versionProperty;
    @Parameter(property="defaultExamplesTags")
    List<String> defaultExamplesTags;
    @Parameter(property="skipTags")
    List<String> skipTags;
    @Parameter(property="filterConfiguration")
    FilterConfiguration filterConfiguration;
    @Parameter(property="projectFilters")
    ProjectFilters projectFilters;
    @Parameter(name="skipComb", defaultValue="false")
    boolean skipComb;
    @Parameter(name="softFilterToHardFilter", defaultValue="false")
    boolean softFilterToHardFilter;

    public void execute() {
        if (this.isSkip() || this.skipComb) {
            this.getLog().warn((CharSequence)"Combine items and generate feature files got skipped due configuration");
            return;
        }
        CombineMojo.setInstance(this);
        this.doChecks();
        FileUtils.deleteDirectory((File)new File(this.outputDir));
        this.execute(this.getConfiguration());
    }

    public void execute(CombineConfiguration config) throws MojoExecutionException {
        String outDir = config.getOutputDir();
        String fileEnding = config.getTemplateFileEnding();
        List<CombineItem> itemsToCombine = Utils.getItemsToCombine(new File(config.getCombineItemFile()), (Mojo)this, true);
        CombineMojo.copyFiles(config.getTemplateDir(), outDir, fileEnding);
        Collection<File> files = CombineMojo.allFiles(outDir, fileEnding);
        if (files.isEmpty()) {
            CombineMojo.getPluginLog().warn((CharSequence)("There are no files to process in " + outDir));
        }
        files.stream().map(file -> CombineMojo.stripEnding(file, fileEnding)).forEach(file -> this.replacer.process((File)file, config, itemsToCombine));
        Utils.writeErrors(((Object)((Object)this)).getClass().getSimpleName(), Stream.of(minimalTableErrorLog, tableSizeErrorLog, propertyErrorLog, warningsLog).flatMap(Collection::stream).collect(Collectors.toList()), WARN_MESSAGE, true);
        if (config.isBreakIfTableToSmall() && !tableSizeErrorLog.isEmpty()) {
            throw new MojoExecutionException("Scenarios with insufficient examples found -> \n" + String.join((CharSequence)"\n", tableSizeErrorLog));
        }
        if (config.isBreakIfMinimalTableError() && !minimalTableErrorLog.isEmpty()) {
            throw new MojoExecutionException(MINIMAL_TABLE_ERROR_HEADER + String.join((CharSequence)"\n\t", minimalTableErrorLog));
        }
    }

    private void doChecks() {
        File templateDirFile = new File(this.templateDir);
        if (!templateDirFile.exists()) {
            throw new MojoExecutionException("Template directory does not exist: " + templateDirFile.getAbsolutePath());
        }
        File file = new File(this.getCombineItemsFile());
        if (!file.exists() || !file.isFile()) {
            throw new MojoExecutionException("Combine items file not found: " + file.getAbsolutePath());
        }
        this.defaultExamplesTags.forEach(this::checkDefaultTag);
    }

    private void checkDefaultTag(String tag) {
        if (!tag.startsWith("@") || tag.lastIndexOf("@") > 0 || tag.trim().contains(" ")) {
            throw new MojoExecutionException(tag + " is not a valid default tag");
        }
        List<String> forbiddenTags = List.of("AllowDoubleLineup", "AllowSelfCombine", "MinimalTable");
        if (forbiddenTags.stream().anyMatch(tag::contains)) {
            throw new MojoExecutionException(String.format("Default tag '%s' is not allowed to contain configuration tags! %s", tag, forbiddenTags));
        }
    }

    private CombineConfiguration getConfiguration() {
        if (this.emptyExamplesTags.isEmpty()) {
            this.emptyExamplesTags = List.of(EMPTY_EXAMPLES_TABLE_TAG, WIP_TAG);
        }
        if (this.skipTags.isEmpty()) {
            this.skipTags = List.of(WIP_TAG);
        }
        if (this.pluginTagCategory == null) {
            this.pluginTagCategory = "Plugin";
        }
        if (this.versionFilterTagCategory == null) {
            this.versionFilterTagCategory = "VersionFilter";
        }
        if (this.versionProperty == null) {
            this.versionProperty = "version";
        }
        if (Objects.nonNull(this.projectFilters)) {
            this.projectFilters.parseProjectFilters();
        }
        if (!this.ending.startsWith(".")) {
            this.ending = String.format(".%s", this.ending);
        }
        return CombineConfiguration.builder().templateDir(this.templateDir).templateFileEnding(this.ending).outputDir(this.outputDir).combineItemFile(this.getCombineItemsFile()).pluginTagCategory(this.pluginTagCategory).versionFilterTagCategory(this.versionFilterTagCategory).emptyExamplesTags(this.emptyExamplesTags).defaultExamplesTags(this.defaultExamplesTags).skipTags(this.skipTags.stream().map(String::toLowerCase).collect(Collectors.toList())).filterConfiguration(this.filterConfiguration).projectFilters(this.projectFilters).breakIfTableToSmall(this.breakIfTableToSmall).minTableSize(this.minTableSize).breakIfMinimalTableError(this.breakIfMinimalTableError).softFilterToHardFilter(this.softFilterToHardFilter).build();
    }

    public static void copyFiles(String from, String to, String ending) {
        File sourceDirectory = new File(from);
        File destinationDirectory = new File(to);
        IOFileFilter fileFilter = FileFilterUtils.suffixFileFilter((String)ending).or(DirectoryFileFilter.DIRECTORY);
        try {
            FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory, (FileFilter)fileFilter);
        }
        catch (FileNotFoundException e) {
            CombineMojo.getPluginLog().error((Throwable)e);
            throw new MojoExecutionException((Throwable)e);
        }
    }

    public static File stripEnding(File file, String ending) {
        File dest = new File(file.getAbsolutePath().replace(ending, ""));
        boolean success = file.renameTo(dest);
        if (!success) {
            CombineMojo.getPluginLog().error((CharSequence)("could not rename " + file.getAbsolutePath() + " to " + dest.getAbsolutePath()));
        }
        return dest;
    }

    public static Collection<File> allFiles(String dir, String ending) {
        File inputDir = new File(dir);
        return FileUtils.listFiles((File)inputDir, (String[])new String[]{ending.replace(".", "")}, (boolean)true);
    }

    public static Log getPluginLog() {
        return CombineMojo.getInstance().getLog();
    }

    public static void appendError(String error, ErrorType type) {
        if (type == ErrorType.SIZE) {
            tableSizeErrorLog.add(error);
        } else if (type == ErrorType.MINIMAL_TABLE) {
            minimalTableErrorLog.add(error);
        } else if (type == ErrorType.PROPERTY) {
            propertyErrorLog.add(error);
        } else if (type == ErrorType.WARNING) {
            warningsLog.add("WARNING: " + error);
        }
    }

    public static void resetError() {
        tableSizeErrorLog = new ArrayList<String>();
        minimalTableErrorLog = new ArrayList<String>();
        propertyErrorLog = new ArrayList<String>();
        warningsLog = new ArrayList<String>();
    }

    @Generated
    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    @Generated
    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    @Generated
    public void setEnding(String ending) {
        this.ending = ending;
    }

    @Generated
    public void setEmptyExamplesTags(List<String> emptyExamplesTags) {
        this.emptyExamplesTags = emptyExamplesTags;
    }

    @Generated
    public void setBreakIfTableToSmall(boolean breakIfTableToSmall) {
        this.breakIfTableToSmall = breakIfTableToSmall;
    }

    @Generated
    public void setMinTableSize(int minTableSize) {
        this.minTableSize = minTableSize;
    }

    @Generated
    public void setBreakIfMinimalTableError(boolean breakIfMinimalTableError) {
        this.breakIfMinimalTableError = breakIfMinimalTableError;
    }

    @Generated
    public void setPluginTagCategory(String pluginTagCategory) {
        this.pluginTagCategory = pluginTagCategory;
    }

    @Generated
    public void setVersionFilterTagCategory(String versionFilterTagCategory) {
        this.versionFilterTagCategory = versionFilterTagCategory;
    }

    @Generated
    public void setVersionProperty(String versionProperty) {
        this.versionProperty = versionProperty;
    }

    @Generated
    public void setDefaultExamplesTags(List<String> defaultExamplesTags) {
        this.defaultExamplesTags = defaultExamplesTags;
    }

    @Generated
    public void setSkipTags(List<String> skipTags) {
        this.skipTags = skipTags;
    }

    @Generated
    public void setFilterConfiguration(FilterConfiguration filterConfiguration) {
        this.filterConfiguration = filterConfiguration;
    }

    @Generated
    public void setProjectFilters(ProjectFilters projectFilters) {
        this.projectFilters = projectFilters;
    }

    @Generated
    public void setSkipComb(boolean skipComb) {
        this.skipComb = skipComb;
    }

    @Generated
    public void setSoftFilterToHardFilter(boolean softFilterToHardFilter) {
        this.softFilterToHardFilter = softFilterToHardFilter;
    }

    @Inject
    @Generated
    public CombineMojo(FileProcessor replacer) {
        this.replacer = replacer;
    }

    @Generated
    public static CombineMojo getInstance() {
        return instance;
    }

    @Generated
    public static void setInstance(CombineMojo instance) {
        CombineMojo.instance = instance;
    }

    @Generated
    public static List<String> getTableSizeErrorLog() {
        return tableSizeErrorLog;
    }

    @Generated
    public static List<String> getMinimalTableErrorLog() {
        return minimalTableErrorLog;
    }

    @Generated
    public static List<String> getPropertyErrorLog() {
        return propertyErrorLog;
    }

    @Generated
    public static List<String> getWarningsLog() {
        return warningsLog;
    }

    @Generated
    public String getPluginTagCategory() {
        return this.pluginTagCategory;
    }

    @Generated
    public String getVersionFilterTagCategory() {
        return this.versionFilterTagCategory;
    }

    @Generated
    public String getVersionProperty() {
        return this.versionProperty;
    }

    static {
        tableSizeErrorLog = new ArrayList<String>();
        minimalTableErrorLog = new ArrayList<String>();
        propertyErrorLog = new ArrayList<String>();
        warningsLog = new ArrayList<String>();
    }

    public static enum ErrorType {
        SIZE,
        MINIMAL_TABLE,
        PROPERTY,
        WARNING;

    }
}

