/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.utils.request;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLContextFactory {
    private SSLContextFactory() {
    }

    public static SSLContext createAndGetSSLContext(String keyStore, String trustStore, String keyStorePassword, String trustStorePassword) {
        KeyManager[] keyManagers = SSLContextFactory.getKeyManagers(keyStore, keyStorePassword);
        TrustManager[] trustManagers = SSLContextFactory.getTrustManagers(trustStore, trustStorePassword);
        SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private static KeyManager[] getKeyManagers(String keyStore, String keyStorePassword) {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("pkcs12");
        try (FileInputStream fis = new FileInputStream(keyStore);){
            ks.load(fis, keyStorePassword.toCharArray());
        }
        keyManagerFactory.init(ks, keyStorePassword.toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] getTrustManagers(String trustStore, String trustStorePassword) {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("pkcs12");
        try (FileInputStream fis = new FileInputStream(trustStore);){
            ks.load(fis, trustStorePassword.toCharArray());
        }
        trustManagerFactory.init(ks);
        return trustManagerFactory.getTrustManagers();
    }

    public static X509TrustManager getX509TrustManager(final String trustStore, final String trustStorePassword) {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return (X509Certificate[])Arrays.stream(SSLContextFactory.getTrustManagers(trustStore, trustStorePassword)).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).toArray(X509Certificate[]::new);
            }
        };
    }
}

