/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.utils;

import de.gematik.combine.CombineMojo;
import de.gematik.combine.model.CombineItem;
import de.gematik.prepare.PrepareItemsMojo;
import io.cucumber.core.internal.com.fasterxml.jackson.core.JsonParseException;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.JsonMappingException;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.cucumber.datatable.internal.difflib.StringUtills;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class Utils {
    private static final DefaultLog nullLogger = new DefaultLog((Logger)new ConsoleLogger());

    public static List<CombineItem> getItemsToCombine(File file, Mojo mojo, boolean useCreated) {
        List<CombineItem> combineItems;
        BufferedReader br;
        ObjectMapper mapper = new ObjectMapper();
        File generatedFile = new File(PrepareItemsMojo.GENERATED_COMBINE_ITEMS_DIR + File.separator + file.getName());
        if (useCreated && generatedFile.exists()) {
            file = generatedFile;
        }
        mojo.getLog().info((CharSequence)String.format("Fetching all items from input file '%s'", file.getAbsolutePath()));
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            mojo.getLog().error((CharSequence)e.getMessage());
            throw new MojoExecutionException(String.format("Can not find combine items file: '%s'", file.getAbsolutePath()), (Exception)e);
        }
        try {
            combineItems = Arrays.asList((CombineItem[])mapper.readValue((Reader)br, CombineItem[].class));
        }
        catch (JsonParseException | JsonMappingException e) {
            mojo.getLog().error((CharSequence)e.getMessage());
            throw new MojoExecutionException(String.format("JSON could not be properly processed -> %s: %s", file.getName(), e.getOriginalMessage()));
        }
        return new ArrayList<CombineItem>(combineItems);
    }

    private static Log getLog() {
        if (Objects.nonNull((Object)CombineMojo.getInstance())) {
            return CombineMojo.getPluginLog();
        }
        if (Objects.nonNull((Object)PrepareItemsMojo.getInstance())) {
            return PrepareItemsMojo.getPluginLog();
        }
        return nullLogger;
    }

    public static void writeErrors(List<String> errors) {
        Utils.writeErrors(errors, null, true);
    }

    public static void writeErrors(List<String> errors, String message, boolean shouldAppend) {
        if (errors.isEmpty()) {
            return;
        }
        if (Objects.nonNull(message)) {
            Utils.getLog().warn((CharSequence)message);
        }
        errors.forEach(arg_0 -> ((Log)Utils.getLog()).warn(arg_0));
        File file = new File(PrepareItemsMojo.GENERATED_COMBINE_ITEMS_DIR + File.separator + "errorLog.txt");
        String errorString = StringUtills.join(errors, (String)"\n") + "\n";
        FileUtils.write((File)file, (CharSequence)errorString, (Charset)StandardCharsets.UTF_8, (boolean)shouldAppend);
    }

    @Generated
    private Utils() {
    }
}

