/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.prepare.request;

import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextFactory {
    private SSLContextFactory() {
    }

    public static SSLContext createAndGetSSLContext(String keyStore, String trustStore, String keyStorePassword, String trustStorePassword) {
        KeyManager[] keyManagers = SSLContextFactory.getKeyManagers(keyStore, keyStorePassword);
        TrustManager[] trustManagers = SSLContextFactory.getTrustManagers(trustStore, trustStorePassword);
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private static KeyManager[] getKeyManagers(String keyStore, String keyStorePassword) {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("pkcs12");
        try (FileInputStream fis = new FileInputStream(keyStore);){
            ks.load(fis, keyStorePassword.toCharArray());
        }
        keyManagerFactory.init(ks, keyStorePassword.toCharArray());
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] getTrustManagers(String trustStore, String trustStorePassword) {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore ks = KeyStore.getInstance("pkcs12");
        try (FileInputStream fis = new FileInputStream(trustStore);){
            ks.load(fis, trustStorePassword.toCharArray());
        }
        trustManagerFactory.init(ks);
        return trustManagerFactory.getTrustManagers();
    }
}

