/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.prepare;

import de.gematik.combine.model.CombineItem;
import de.gematik.prepare.ItemsCreator;
import de.gematik.prepare.PrepareItemsConfig;
import de.gematik.prepare.PropertyExpression;
import de.gematik.prepare.TagExpression;
import de.gematik.prepare.request.ApiRequester;
import de.gematik.utils.Utils;
import io.cucumber.core.internal.com.fasterxml.jackson.core.JsonProcessingException;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;

@org.apache.maven.plugins.annotations.Mojo(name="prepare-items", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class PrepareItemsMojo
extends AbstractMojo {
    public static final String WARN_MESSAGE = "=== Caution!!! The generated file have modified your input file significantly! ===";
    public static final String GENERATED_COMBINE_ITEMS_DIR = "target" + File.separator + "generated-combine";
    private static final List<String> apiErrors = new ArrayList<String>();
    private static PrepareItemsMojo instance;
    private final ApiRequester apiRequester;
    @Parameter(property="combineItemsFile", defaultValue="./src/test/resources/combine_items.json")
    String combineItemsFile;
    @Parameter(property="infoResourceLocation")
    String infoResourceLocation;
    @Parameter(property="tagExpressions")
    List<TagExpression> tagExpressions;
    @Parameter(property="propertyExpressions")
    List<PropertyExpression> propertyExpressions;
    @Parameter(property="truststore")
    String truststore;
    @Parameter(property="truststorePw")
    String truststorePw;
    @Parameter(property="clientCertStore")
    String clientCertStore;
    @Parameter(property="clientCertStorePw")
    String clientCertStorePw;
    @Parameter(property="hardFail", defaultValue="true")
    boolean hardFail;
    @Parameter(property="configFail", defaultValue="true")
    boolean configFail;
    private ItemsCreator itemsCreator;
    private List<CombineItem> items;

    public static Log getPluginLog() {
        return instance.getLog();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        PrepareItemsMojo.setInstance(this);
        this.checkExpressionSetCorrectly();
        this.getLog().info((CharSequence)("Going to preprocess " + this.combineItemsFile));
        this.itemsCreator = new ItemsCreator(this.getCreateItemsConfig());
        this.items = Utils.getItemsToCombine(new File(this.combineItemsFile), (Mojo)PrepareItemsMojo.getInstance(), false);
        this.apiRequester.setupTls(this.truststore, this.truststorePw, this.clientCertStore, this.clientCertStorePw);
        this.run();
    }

    protected void checkExpressionSetCorrectly() throws MojoExecutionException {
        Optional<TagExpression> checkTag = this.tagExpressions.stream().filter(t -> t.getExpression() == null || t.getTag() == null).findAny();
        if (checkTag.isPresent()) {
            throw new MojoExecutionException(String.format("Erroneous configuration: missing %s in %s", checkTag.get().getExpression() == null ? "expression" : "tag", checkTag.get()));
        }
        Optional<PropertyExpression> checkProperty = this.propertyExpressions.stream().filter(t -> t.getExpression() == null || t.getProperty() == null).findAny();
        if (checkProperty.isPresent()) {
            throw new MojoExecutionException(String.format("Erroneous configuration: missing %s in %s", checkProperty.get().getExpression() == null ? "expression" : "property", checkProperty.get()));
        }
    }

    protected void run() throws MojoExecutionException {
        List<CombineItem> processedItems = this.items.stream().map(this::processItem).filter(Objects::nonNull).collect(Collectors.toList());
        Utils.writeErrors(apiErrors, WARN_MESSAGE, false);
        Utils.writeErrors(this.itemsCreator.getConfigErrors());
        if (this.hardFail && !apiErrors.isEmpty()) {
            throw new MojoExecutionException("Error occurred for following API`s ->\n" + String.join((CharSequence)"\n", apiErrors));
        }
        if (this.configFail && !this.itemsCreator.getConfigErrors().isEmpty()) {
            throw new MojoExecutionException("Different tags or properties where found ->\n" + String.join((CharSequence)"\n", this.itemsCreator.getConfigErrors()));
        }
        this.writeItemsToFile(processedItems);
    }

    private CombineItem processItem(CombineItem item) {
        String url = item.getUrl() == null ? item.getValue() : item.getUrl();
        try {
            this.getLog().info((CharSequence)("Connecting to " + url));
            Map<?, ?> apiInfo = this.getApiInfo((String)(Objects.nonNull(this.infoResourceLocation) ? url + this.infoResourceLocation : url));
            this.itemsCreator.evaluateExpressions(item, apiInfo);
            return item;
        }
        catch (MojoExecutionException ex) {
            apiErrors.add(item.getValue() + (String)(Objects.nonNull(item.getUrl()) ? " -> " + item.getUrl() : "") + " -> not reachable");
            this.getLog().error((CharSequence)("Could not connect to api: " + item.getValue() + (String)(Objects.nonNull(item.getUrl()) ? " url: " + item.getUrl() : "")));
        }
        catch (JsonProcessingException ex) {
            apiErrors.add(url + " -> could not parse JSON");
            this.getLog().error((CharSequence)("Could not parse JSON from " + url), (Throwable)ex);
        }
        return null;
    }

    private Map<?, ?> getApiInfo(String url) throws MojoExecutionException, JsonProcessingException {
        String apiResponse = this.apiRequester.getApiResponse(url);
        return (Map)new ObjectMapper().readValue(apiResponse, Map.class);
    }

    private void writeItemsToFile(List<CombineItem> items) {
        String fileName = GENERATED_COMBINE_ITEMS_DIR + File.separator + new File(this.combineItemsFile).getName();
        this.getLog().info((CharSequence)("Created new combine item file -> " + fileName));
        FileUtils.writeStringToFile((File)new File(fileName), (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(items), (Charset)StandardCharsets.UTF_8);
    }

    private PrepareItemsConfig getCreateItemsConfig() {
        return PrepareItemsConfig.builder().combineItemsFile(this.combineItemsFile).infoResourceLocation(this.infoResourceLocation).tagExpressions(this.tagExpressions).propertyExpressions(this.propertyExpressions).build();
    }

    @Generated
    public void setCombineItemsFile(String combineItemsFile) {
        this.combineItemsFile = combineItemsFile;
    }

    @Generated
    public void setInfoResourceLocation(String infoResourceLocation) {
        this.infoResourceLocation = infoResourceLocation;
    }

    @Generated
    public void setTagExpressions(List<TagExpression> tagExpressions) {
        this.tagExpressions = tagExpressions;
    }

    @Generated
    public void setPropertyExpressions(List<PropertyExpression> propertyExpressions) {
        this.propertyExpressions = propertyExpressions;
    }

    @Generated
    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    @Generated
    public void setTruststorePw(String truststorePw) {
        this.truststorePw = truststorePw;
    }

    @Generated
    public void setClientCertStore(String clientCertStore) {
        this.clientCertStore = clientCertStore;
    }

    @Generated
    public void setClientCertStorePw(String clientCertStorePw) {
        this.clientCertStorePw = clientCertStorePw;
    }

    @Generated
    public void setHardFail(boolean hardFail) {
        this.hardFail = hardFail;
    }

    @Generated
    public void setConfigFail(boolean configFail) {
        this.configFail = configFail;
    }

    @Generated
    public void setItemsCreator(ItemsCreator itemsCreator) {
        this.itemsCreator = itemsCreator;
    }

    @Generated
    public void setItems(List<CombineItem> items) {
        this.items = items;
    }

    @Inject
    @Generated
    public PrepareItemsMojo(ApiRequester apiRequester) {
        this.apiRequester = apiRequester;
    }

    @Generated
    public static PrepareItemsMojo getInstance() {
        return instance;
    }

    @Generated
    public static void setInstance(PrepareItemsMojo instance) {
        PrepareItemsMojo.instance = instance;
    }
}

