/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.prepare;

import de.gematik.combine.model.CombineItem;
import de.gematik.prepare.PrepareItemsConfig;
import de.gematik.prepare.PrepareItemsMojo;
import de.gematik.prepare.PropertyExpression;
import de.gematik.prepare.TagExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.MapContext;

public class ItemsCreator {
    private static final String ERROR_START = "Error for api: ";
    private final PrepareItemsConfig config;
    private JexlContext context;
    private final List<String> configErrors = new ArrayList<String>();
    public static final JexlEngine JEXL_ENGINE = new JexlBuilder().strict(true).silent(false).safe(false).create();

    public ItemsCreator(PrepareItemsConfig config) {
        this.config = config;
    }

    public Void evaluateExpressions(CombineItem item, Map<?, ?> jsonContext) {
        this.context = new MapContext();
        this.context.set("$", jsonContext);
        this.config.getTagExpressions().forEach(e -> this.checkTagExpression(item, (TagExpression)e));
        this.config.getPropertyExpressions().forEach(e -> this.checkPropertyExpression(item, (PropertyExpression)e));
        return null;
    }

    private void checkTagExpression(CombineItem item, TagExpression tagExpression) {
        PrepareItemsMojo.getPluginLog().debug((CharSequence)("Evaluating tag expression -> " + tagExpression.getExpression() + " - " + tagExpression.getTag()));
        HashSet<String> newTags = new HashSet<String>(item.getTags());
        try {
            Boolean result = (Boolean)JEXL_ENGINE.createExpression(tagExpression.getExpression()).evaluate(this.context);
            if (result != null && result.booleanValue()) {
                newTags.add(tagExpression.getTag());
            } else if (item.getTags().contains(tagExpression.getTag())) {
                this.configErrors.add(ERROR_START + item.getValue() + " -> for tag " + tagExpression.getTag() + " extension " + tagExpression.getExpression() + " should return true");
                newTags.remove(tagExpression.getTag());
            }
        }
        catch (JexlException ex) {
            PrepareItemsMojo.getPluginLog().warn((CharSequence)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        item.setTags(newTags);
    }

    private void checkPropertyExpression(CombineItem item, PropertyExpression propertyExpression) {
        Map.Entry<String, String> entry = this.evaluatePropertyExpression(propertyExpression, item.getProperties(), item);
        HashMap<String, String> propertiesCopy = new HashMap<String, String>(item.getProperties());
        if (entry != null) {
            propertiesCopy.put(entry.getKey(), entry.getValue());
            item.setProperties(propertiesCopy);
        } else {
            item.getProperties().remove(propertyExpression.getProperty());
        }
    }

    private Map.Entry<String, String> evaluatePropertyExpression(PropertyExpression propertyExpression, Map<String, String> existingProperties, CombineItem item) {
        String existingProperty;
        String value;
        PrepareItemsMojo.getPluginLog().debug((CharSequence)("evaluating " + propertyExpression.getExpression()));
        try {
            value = (String)JEXL_ENGINE.createExpression(propertyExpression.getExpression()).evaluate(this.context);
        }
        catch (JexlException ex) {
            PrepareItemsMojo.getPluginLog().warn((CharSequence)ex.getMessage());
            return null;
        }
        if (value == null) {
            this.configErrors.add(ERROR_START + item.getValue() + (String)(Objects.nonNull(item.getUrl()) ? " url: " + item.getUrl() : "") + " -> at property " + propertyExpression.getProperty() + ": Could not find any value at -> " + propertyExpression.getExpression());
            return null;
        }
        if (existingProperties.containsKey(propertyExpression.getProperty()) && !value.equals(existingProperty = existingProperties.get(propertyExpression.getProperty()))) {
            this.configErrors.add(ERROR_START + item.getValue() + (String)(Objects.nonNull(item.getUrl()) ? " url: " + item.getUrl() : "") + " -> at property " + propertyExpression.getProperty() + ": Found value -> \"" + value + "\" differ from -> \"" + existingProperty + "\" for expression -> " + propertyExpression.getExpression());
        }
        Map.Entry<String, String> keyValue = Map.entry(propertyExpression.getProperty(), value);
        PrepareItemsMojo.getPluginLog().debug((CharSequence)("proceeded property -> " + keyValue));
        return keyValue;
    }

    @Generated
    public List<String> getConfigErrors() {
        return this.configErrors;
    }
}

