/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.tags;

import de.gematik.combine.CombineMojo;
import de.gematik.combine.tags.ParsedTags;
import de.gematik.combine.tags.SingleTagParser;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import lombok.Generated;

public class TagParser {
    private static final Pattern tagPattern = Pattern.compile("@([a-zA-Z0-9_-]+)(?:\\((.*)\\))?");
    private final Map<String, SingleTagParser> tagParsers;

    public ParsedTags parseTags(List<String> tags, List<String> columns) {
        ParsedTags tagCollector = new ParsedTags(columns);
        tags.stream().map(this::preParseTag).flatMap(Optional::stream).forEach(tag -> this.parseTag((PreParsedTag)tag, tagCollector));
        return tagCollector;
    }

    private void parseTag(PreParsedTag preParsedTag, ParsedTags tagCollector) {
        SingleTagParser tagParser = this.tagParsers.get(preParsedTag.getTagName());
        if (tagParser == null) {
            CombineMojo.getPluginLog().warn((CharSequence)("ignoring unknown tag: " + preParsedTag));
            return;
        }
        tagParser.parseTagAndRegister(preParsedTag.getValue(), tagCollector);
    }

    private Optional<PreParsedTag> preParseTag(String tag) {
        Matcher matcher = tagPattern.matcher(tag);
        boolean matches = matcher.matches();
        if (!matches) {
            CombineMojo.getPluginLog().warn((CharSequence)(tag + " does not match format for tags"));
            return Optional.empty();
        }
        String shortName = matcher.group(1);
        boolean hasValue = matcher.groupCount() == 2;
        String value = null;
        if (hasValue) {
            value = matcher.group(2);
        }
        return Optional.of(new PreParsedTag(shortName, value));
    }

    @Inject
    @Generated
    public TagParser(Map<String, SingleTagParser> tagParsers) {
        this.tagParsers = tagParsers;
    }

    public static class PreParsedTag {
        final String tagName;
        final String value;

        public String toString() {
            return "@" + this.tagName + "(" + this.value + ")";
        }

        @Generated
        public String getTagName() {
            return this.tagName;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public PreParsedTag(String tagName, String value) {
            this.tagName = tagName;
            this.value = value;
        }
    }
}

