/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.model.properties;

import java.lang.reflect.MalformedParametersException;
import java.util.LinkedList;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public class Version
implements Comparable<Version> {
    private final LinkedList<Integer> versionParts;

    @NonNull
    public static Version getSemanticVersion(String versionString) throws MalformedParametersException {
        LinkedList<Integer> versionParts = new LinkedList<Integer>();
        try {
            for (String versionPartString : versionString.trim().split("\\.")) {
                versionParts.add(Integer.parseInt(versionPartString));
            }
        }
        catch (NumberFormatException ignored) {
            throw new MalformedParametersException(String.format("Version may only contain numbers and dots(.), does not match: %s", versionString));
        }
        if (versionParts.isEmpty()) {
            throw new MalformedParametersException("Version may not be empty");
        }
        return new Version(versionParts);
    }

    @Override
    public int compareTo(Version o) {
        for (int i = 0; i < Math.max(this.versionParts.size(), o.versionParts.size()); ++i) {
            int otherPart;
            int thisPart = i < this.versionParts.size() ? this.versionParts.get(i) : 0;
            int n = otherPart = i < o.versionParts.size() ? o.versionParts.get(i) : 0;
            if (thisPart > otherPart) {
                return 1;
            }
            if (thisPart >= otherPart) continue;
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.versionParts.stream().map(Object::toString).collect(Collectors.joining("."));
    }

    @Generated
    public Version(LinkedList<Integer> versionParts) {
        this.versionParts = versionParts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LinkedList<Integer> this$versionParts = this.versionParts;
        LinkedList<Integer> other$versionParts = other.versionParts;
        return !(this$versionParts == null ? other$versionParts != null : !((Object)this$versionParts).equals(other$versionParts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LinkedList<Integer> $versionParts = this.versionParts;
        result = result * 59 + ($versionParts == null ? 43 : ((Object)$versionParts).hashCode());
        return result;
    }
}

