/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.model;

import de.gematik.combine.CombineMojo;
import de.gematik.combine.util.NonNullableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class CombineItem
implements Comparable<CombineItem> {
    public static final String DEFAULT_PROPERTY = "";
    private String value;
    private String url;
    private Set<String> tags = new HashSet<String>();
    private Map<String, String> properties = new HashMap<String, String>();

    public String toString() {
        return this.value;
    }

    public boolean hasTag(String tag) {
        return this.getTags().contains(tag);
    }

    public boolean hasProperty(String property) {
        return this.properties.containsKey(property);
    }

    public Map<String, String> getProperties() {
        return NonNullableMap.nonNullableMap(this.properties, this::getDefaultPropertyAndLog);
    }

    @Override
    public int compareTo(CombineItem other) {
        return this.value.compareTo(other.value);
    }

    private String getDefaultPropertyAndLog(String key) {
        CombineMojo.getPluginLog().info((CharSequence)String.format("item %s does not have property %s", this.value, key));
        return DEFAULT_PROPERTY;
    }

    @Generated
    public static CombineItemBuilder builder() {
        return new CombineItemBuilder();
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Generated
    public CombineItem() {
    }

    @Generated
    public CombineItem(String value, String url, Set<String> tags, Map<String, String> properties) {
        this.value = value;
        this.url = url;
        this.tags = tags;
        this.properties = properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CombineItem)) {
            return false;
        }
        CombineItem other = (CombineItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CombineItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Generated
    public static class CombineItemBuilder {
        @Generated
        private String value;
        @Generated
        private String url;
        @Generated
        private ArrayList<String> tags;
        @Generated
        private ArrayList<String> properties$key;
        @Generated
        private ArrayList<String> properties$value;

        @Generated
        CombineItemBuilder() {
        }

        @Generated
        public CombineItemBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public CombineItemBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public CombineItemBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        @Generated
        public CombineItemBuilder tags(Collection<? extends String> tags) {
            if (tags == null) {
                throw new NullPointerException("tags cannot be null");
            }
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        @Generated
        public CombineItemBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        @Generated
        public CombineItemBuilder property(String propertyKey, String propertyValue) {
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            this.properties$key.add(propertyKey);
            this.properties$value.add(propertyValue);
            return this;
        }

        @Generated
        public CombineItemBuilder properties(Map<? extends String, ? extends String> properties) {
            if (properties == null) {
                throw new NullPointerException("properties cannot be null");
            }
            if (this.properties$key == null) {
                this.properties$key = new ArrayList();
                this.properties$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : properties.entrySet()) {
                this.properties$key.add($lombokEntry.getKey());
                this.properties$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public CombineItemBuilder clearProperties() {
            if (this.properties$key != null) {
                this.properties$key.clear();
                this.properties$value.clear();
            }
            return this;
        }

        @Generated
        public CombineItem build() {
            Map<String, String> properties;
            Set<Object> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptySet();
                    break;
                }
                case 1: {
                    tags = Collections.singleton(this.tags.get(0));
                    break;
                }
                default: {
                    tags = new LinkedHashSet(this.tags.size() < 0x40000000 ? 1 + this.tags.size() + (this.tags.size() - 3) / 3 : Integer.MAX_VALUE);
                    tags.addAll(this.tags);
                    tags = Collections.unmodifiableSet(tags);
                }
            }
            switch (this.properties$key == null ? 0 : this.properties$key.size()) {
                case 0: {
                    properties = Collections.emptyMap();
                    break;
                }
                case 1: {
                    properties = Collections.singletonMap(this.properties$key.get(0), this.properties$value.get(0));
                    break;
                }
                default: {
                    properties = new LinkedHashMap(this.properties$key.size() < 0x40000000 ? 1 + this.properties$key.size() + (this.properties$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.properties$key.size(); ++$i) {
                        properties.put(this.properties$key.get($i), this.properties$value.get($i));
                    }
                    properties = Collections.unmodifiableMap(properties);
                }
            }
            return new CombineItem(this.value, this.url, tags, properties);
        }

        @Generated
        public String toString() {
            return "CombineItem.CombineItemBuilder(value=" + this.value + ", url=" + this.url + ", tags=" + this.tags + ", properties$key=" + this.properties$key + ", properties$value=" + this.properties$value + ")";
        }
    }
}

