/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter.table.cell;

import de.gematik.combine.CombineMojo;
import de.gematik.combine.filter.table.cell.CellFilter;
import de.gematik.combine.model.TableCell;
import de.gematik.combine.model.properties.Version;
import de.gematik.combine.util.CompareOperator;
import java.util.Objects;
import lombok.Generated;

public class VersionFilter
implements CellFilter {
    private final CompareOperator operator;
    private final Version filterVersion;

    @Override
    public boolean test(TableCell tableCell) {
        String versionProperty = CombineMojo.getInstance().getVersionProperty();
        if (!tableCell.hasProperty(versionProperty)) {
            CombineMojo.appendError(String.format("version property is missing for -> value: %s%s", tableCell.getValue(), Objects.nonNull(tableCell.getUrl()) ? String.format(" url: %s", tableCell.getUrl()) : ""), CombineMojo.ErrorType.PROPERTY);
            return false;
        }
        Version itemVersion = Version.getSemanticVersion(tableCell.getProperties().get(versionProperty));
        return this.operator.includesResultOf(itemVersion.compareTo(this.filterVersion));
    }

    public String toString() {
        return String.format("%s%s", this.operator.getLiteral(), this.filterVersion);
    }

    @Generated
    public CompareOperator getOperator() {
        return this.operator;
    }

    @Generated
    public Version getFilterVersion() {
        return this.filterVersion;
    }

    @Generated
    public VersionFilter(CompareOperator operator, Version filterVersion) {
        this.operator = operator;
        this.filterVersion = filterVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionFilter)) {
            return false;
        }
        VersionFilter other = (VersionFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompareOperator this$operator = this.getOperator();
        CompareOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        Version this$filterVersion = this.getFilterVersion();
        Version other$filterVersion = other.getFilterVersion();
        return !(this$filterVersion == null ? other$filterVersion != null : !((Object)this$filterVersion).equals(other$filterVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VersionFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompareOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)((Object)$operator)).hashCode());
        Version $filterVersion = this.getFilterVersion();
        result = result * 59 + ($filterVersion == null ? 43 : ((Object)$filterVersion).hashCode());
        return result;
    }
}

