/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.filter.table;

import de.gematik.combine.CombineMojo;
import de.gematik.combine.filter.table.TableFilter;
import de.gematik.combine.model.TableCell;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;

public class DoubleLineupFilter
implements TableFilter {
    private final boolean allow;

    @Override
    public List<List<TableCell>> apply(List<List<TableCell>> table) {
        if (this.allow) {
            return table;
        }
        CombineMojo.getPluginLog().debug((CharSequence)String.format("applying %s on %d rows", this, table.size()));
        TreeSet combinationSet = new TreeSet();
        return table.stream().filter(row -> {
            String sortedCellValues = row.stream().map(TableCell::getValue).sorted().collect(Collectors.joining());
            return combinationSet.add(sortedCellValues);
        }).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "DoubleLineupFilter(allow=" + this.allow + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleLineupFilter)) {
            return false;
        }
        DoubleLineupFilter other = (DoubleLineupFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.allow == other.allow;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DoubleLineupFilter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.allow ? 79 : 97);
        return result;
    }

    @Generated
    public DoubleLineupFilter(boolean allow) {
        this.allow = allow;
    }
}

