/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.combine.execution;

import de.gematik.combine.CombineConfiguration;
import de.gematik.combine.CombineMojo;
import de.gematik.combine.execution.GherkinProcessor;
import de.gematik.combine.model.CombineItem;
import io.cucumber.gherkin.GherkinParser;
import io.cucumber.gherkin.utils.pretty.Pretty;
import io.cucumber.gherkin.utils.pretty.Syntax;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;

public class FileProcessor {
    private final GherkinProcessor gherkinProcessor;

    public void process(File file, CombineConfiguration config, List<CombineItem> combineItems) {
        GherkinDocument gherkinDocument;
        CombineMojo.getPluginLog().info((CharSequence)("processing: " + file.getName()));
        CombineMojo.getPluginLog().debug((CharSequence)("file: " + file.getAbsolutePath()));
        String oldContent = Files.readString(file.toPath());
        try {
            gherkinDocument = FileProcessor.parseGherkinString(oldContent);
            CombineMojo.getPluginLog().debug((CharSequence)("parsed gherkin from: " + file.getAbsolutePath()));
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage() + " " + file.getAbsolutePath());
        }
        this.gherkinProcessor.process(gherkinDocument, config, combineItems);
        CombineMojo.getPluginLog().debug((CharSequence)("writing result to: " + file.getAbsolutePath()));
        String newContent = Pretty.prettyPrint((GherkinDocument)gherkinDocument, (Syntax)Syntax.gherkin);
        Files.writeString(file.toPath(), (CharSequence)newContent, new OpenOption[0]);
        CombineMojo.getPluginLog().info((CharSequence)("processed: " + file.getName()));
    }

    private static GherkinDocument parseGherkinString(String gherkin) {
        GherkinParser parser = GherkinParser.builder().includeSource(false).includePickles(false).includeGherkinDocument(true).build();
        Source source = new Source("not needed", gherkin, SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN);
        Envelope envelope = Envelope.of((Source)source);
        return (GherkinDocument)parser.parse(envelope).map(Envelope::getGherkinDocument).flatMap(Optional::stream).findAny().orElseThrow(() -> new IllegalArgumentException("Could not parse invalid gherkin."));
    }

    @Inject
    @Generated
    public FileProcessor(GherkinProcessor gherkinProcessor) {
        this.gherkinProcessor = gherkinProcessor;
    }
}

