/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.exceptions.ParsingException;
import de.gematik.bbriccs.vsdm.types.VsdmKeyVersion;
import de.gematik.bbriccs.vsdm.types.VsdmVendorIdentifier;
import java.util.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class VsdmVendorIdentifierTest {
    private static final String CHECK_DIGIT_VERSION_V1 = "WTc4NTcyODA3MTE2ODU0NDA4MzdVQzEpQdKViiyA4SGBIjkJuPVMWhLD6OBwggI=";
    private static final String CHECK_DIGIT_VERSION_V2 = "3gyWVfvt1Yncz80adEC997AOEMJAzBxElpKwgyPfL+mGjrG31Yo4AqT9vT168v0=";

    VsdmVendorIdentifierTest() {
    }

    @Test
    void shouldParseValidDataForVersion1() {
        byte[] data = Base64.getDecoder().decode(CHECK_DIGIT_VERSION_V1);
        VsdmVendorIdentifier result = VsdmVendorIdentifier.parseV1((byte[])data);
        Assertions.assertEquals((char)'C', (char)result.identifier());
    }

    @Test
    void shouldParseValidDataForVersion2() {
        byte[] data = Base64.getDecoder().decode(CHECK_DIGIT_VERSION_V2);
        VsdmCheckDigitVersion version = VsdmCheckDigitVersion.V2;
        VsdmVendorIdentifier result = VsdmVendorIdentifier.parseV2((byte[])data, (VsdmKeyVersion)new VsdmKeyVersion('2', version));
        Assertions.assertEquals((char)'X', (char)result.identifier());
    }

    @Test
    void shouldThrowParsingExceptionForInvalidData() {
        byte[] data = new byte[]{};
        Assertions.assertThrows(ParsingException.class, () -> VsdmVendorIdentifier.parseV1((byte[])data));
    }

    @Test
    void shouldThrowParsingExceptionForEmptyData() {
        byte[] data = new byte[]{};
        Assertions.assertThrows(ParsingException.class, () -> VsdmVendorIdentifier.parseV1((byte[])data));
    }

    @Test
    void shouldThrowParsingExceptionForNullData() {
        byte[] data = null;
        Assertions.assertThrows(NullPointerException.class, () -> VsdmVendorIdentifier.parseV1((byte[])data));
    }

    @Test
    void shouldThrowParsingExceptionForDataWithNonAsciiCharacters() {
        byte[] data = new byte[]{-61, -87};
        Assertions.assertThrows(ParsingException.class, () -> VsdmVendorIdentifier.parseV1((byte[])data));
    }

    @ParameterizedTest
    @ValueSource(bytes={64, 97, 32, 1})
    void shouldThrowParsingExceptionForDataWithSpecialCharacters(byte value) {
        byte[] data = new byte[]{value};
        Assertions.assertThrows(ParsingException.class, () -> VsdmVendorIdentifier.parseV1((byte[])data));
    }

    @Test
    void shouldReturnHashCode() {
        VsdmVendorIdentifier identifier = new VsdmVendorIdentifier('A', VsdmCheckDigitVersion.V1);
        Assertions.assertDoesNotThrow(() -> ((VsdmVendorIdentifier)identifier).hashCode());
    }

    @ParameterizedTest
    @ValueSource(chars={65, 41, 49})
    void shouldHandleDifferentIdentifier(char value) {
        byte[] data = new byte[]{(byte)value};
        Assertions.assertDoesNotThrow(() -> VsdmVendorIdentifier.parseV2((byte[])data, (VsdmKeyVersion)new VsdmKeyVersion('I', VsdmCheckDigitVersion.V2)));
    }
}

