/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.exceptions.ParsingException;
import de.gematik.bbriccs.vsdm.exceptions.ParsingUpdateResonException;
import de.gematik.bbriccs.vsdm.types.VsdmKvnr;
import de.gematik.bbriccs.vsdm.types.VsdmUpdateReason;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class VsdmUpdateReasonTest {
    VsdmUpdateReasonTest() {
    }

    @Test
    void shouldThrowParsingUpdateResonExceptionForInvalidIdentifier() {
        char invalidIdentifier = 'X';
        Assertions.assertThrows(ParsingUpdateResonException.class, () -> VsdmUpdateReason.fromChecksum((char)invalidIdentifier));
    }

    @Test
    void shouldThrowParsingExceptionForInvalidDataV1() {
        byte[] data = new byte[1];
        Assertions.assertThrows(ParsingException.class, () -> VsdmKvnr.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V1));
    }

    @Test
    void shouldThrowParsingExceptionForInvalidDataV2() {
        byte[] data = new byte[1];
        Assertions.assertThrows(ParsingException.class, () -> VsdmKvnr.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V2));
    }

    @Test
    void shouldReturnCorrectDescriptionForUfsUpdate() {
        VsdmUpdateReason reason = VsdmUpdateReason.UFS_UPDATE;
        Assertions.assertEquals((Object)"Update Flag Service (UFS) Anfrage", (Object)reason.getDescription());
    }

    @Test
    void shouldReturnCorrectIdentifierForVsdUpdate() {
        VsdmUpdateReason reason = VsdmUpdateReason.VSD_UPDATE;
        Assertions.assertEquals((char)'V', (char)reason.getIdentifier());
    }

    @Test
    void shouldGenerateCorrectByteForCardManagementUpdate() {
        VsdmUpdateReason reason = VsdmUpdateReason.CARD_MANAGEMENT_UPDATE;
        Assertions.assertEquals((byte)67, (byte)reason.generate());
    }

    @Test
    void shouldReturnCorrectStringRepresentationForInvalidReason() {
        VsdmUpdateReason reason = VsdmUpdateReason.INVALID;
        Assertions.assertEquals((Object)"Identifier I Description: Invalid Reason (Test purpose)", (Object)reason.toString());
    }

    static Stream<Arguments> shouldReturnCorrectUpdateReasonFromChecksum() {
        return Stream.of(Arguments.of((Object[])new Object[]{Character.valueOf('U'), VsdmUpdateReason.UFS_UPDATE}), Arguments.of((Object[])new Object[]{Character.valueOf('V'), VsdmUpdateReason.VSD_UPDATE}), Arguments.of((Object[])new Object[]{Character.valueOf('C'), VsdmUpdateReason.CARD_MANAGEMENT_UPDATE}));
    }

    @ParameterizedTest
    @MethodSource(value={"shouldReturnCorrectUpdateReasonFromChecksum"})
    void shouldReturnCorrectUpdateReasonFromChecksum(char identifier, VsdmUpdateReason expectedReason) throws ParsingUpdateResonException {
        VsdmUpdateReason reason = VsdmUpdateReason.fromChecksum((char)identifier);
        Assertions.assertEquals((Object)expectedReason, (Object)reason);
    }

    @Test
    void shouldThrowParsingUpdateResonExceptionForUnknownIdentifier() {
        char unknownIdentifier = 'Z';
        Assertions.assertThrows(ParsingUpdateResonException.class, () -> VsdmUpdateReason.fromChecksum((char)unknownIdentifier));
    }
}

