/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmUtils;
import de.gematik.bbriccs.vsdm.types.VsdmKvnr;
import de.gematik.bbriccs.vsdm.types.VsdmPatient;
import java.time.LocalDate;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class VsdmPatientTest {
    VsdmPatientTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"shouldGenerateHashSuccessfulTestdata"})
    void shouldGenerateHashSuccessful(LocalDate insuranceStartDate, String street, String expectedHash) {
        Assertions.assertEquals((Object)expectedHash, (Object)VsdmUtils.bytesToHex((byte[])VsdmPatient.generateHash((LocalDate)insuranceStartDate, (String)street)).toLowerCase().replace(" ", ""));
    }

    @Test
    void shouldThrowExceptions() {
        Assertions.assertThrows(NullPointerException.class, () -> VsdmPatient.generateHash(null, null));
        LocalDate date = LocalDate.now();
        Assertions.assertThrows(NullPointerException.class, () -> VsdmPatient.generateHash((LocalDate)date, null));
        Assertions.assertThrows(NullPointerException.class, () -> VsdmPatient.generateHash(null, (String)""));
    }

    @Test
    void testCreateVsdmPatient() {
        Assertions.assertDoesNotThrow(() -> new VsdmPatient(VsdmKvnr.from((String)"A123456789"), LocalDate.now()));
        VsdmPatient patient = new VsdmPatient(VsdmKvnr.from((String)"A123456789"), LocalDate.now());
        Assertions.assertEquals((Object)"", (Object)patient.getStreet());
        Assertions.assertNotNull((Object)patient.getInsuranceStartDate());
    }

    public Stream<Arguments> shouldGenerateHashSuccessfulTestdata() {
        return Stream.of(Arguments.of((Object[])new Object[]{LocalDate.parse("2019-02-12"), "", "4885ee8394"}), Arguments.of((Object[])new Object[]{LocalDate.parse("1998-11-23"), "Berliner Stra\u00dfe", "6545491d14"}), Arguments.of((Object[])new Object[]{LocalDate.parse("1984-10-03"), "Angerm\u00fcnder Stra\u00dfe", "7cc49e7af4"}), Arguments.of((Object[])new Object[]{LocalDate.parse("2001-01-19"), "Bj\u00f6rnsonstra\u00dfe", "186269e4f7"}), Arguments.of((Object[])new Object[]{LocalDate.parse("2004-07-18"), "Sch\u00f6nhauser Allee", "353646b5c8"}));
    }
}

