/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.exceptions.ParsingException;
import de.gematik.bbriccs.vsdm.types.VsdmKvnr;
import java.util.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class VsdmKvnrTest {
    private static final String CHECK_DIGIT_DECRYPTED_V2 = "EL5l82UB9gJBMTIzNDU2Nzg5";

    VsdmKvnrTest() {
    }

    @Test
    void shouldGenerateCorrectByteArray() {
        VsdmKvnr vsdmKvnr = new VsdmKvnr("1234567890");
        byte[] result = vsdmKvnr.generate();
        Assertions.assertArrayEquals((byte[])"1234567890".getBytes(), (byte[])result);
    }

    @Test
    void shouldParseCorrectKvnrForV1() {
        byte[] data = "1234567890".getBytes();
        VsdmKvnr vsdmKvnr = VsdmKvnr.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V1);
        Assertions.assertEquals((Object)"1234567890", (Object)vsdmKvnr.kvnr());
    }

    @Test
    void shouldParseCorrectKvnrForV2() {
        byte[] data = Base64.getDecoder().decode(CHECK_DIGIT_DECRYPTED_V2);
        VsdmKvnr vsdmKvnr = VsdmKvnr.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V2);
        Assertions.assertEquals((Object)"A123456789", (Object)vsdmKvnr.kvnr());
        Assertions.assertEquals((Object)"A123456789", (Object)vsdmKvnr.toString());
    }

    @Test
    void shouldThrowParsingExceptionForInvalidDataV1() {
        byte[] data = new byte[1];
        Assertions.assertThrows(ParsingException.class, () -> VsdmKvnr.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V1));
    }

    @Test
    void shouldThrowParsingExceptionForInvalidDataV2() {
        byte[] data = new byte[5];
        Assertions.assertThrows(ParsingException.class, () -> VsdmKvnr.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V2));
    }

    @Test
    void shouldReturnTrueForEqualKvnrObjects() {
        VsdmKvnr vsdmKvnr1 = new VsdmKvnr("1234567890");
        VsdmKvnr vsdmKvnr2 = new VsdmKvnr("1234567890");
        Assertions.assertEquals((Object)vsdmKvnr1, (Object)vsdmKvnr2);
    }

    @Test
    void shouldReturnFalseForNonEqualKvnrObjects() {
        VsdmKvnr vsdmKvnr1 = new VsdmKvnr("1234567890");
        VsdmKvnr vsdmKvnr2 = new VsdmKvnr("0987654321");
        Assertions.assertNotEquals((Object)vsdmKvnr1, (Object)vsdmKvnr2);
    }

    @Test
    void shouldReturnFalseForNullComparison() {
        VsdmKvnr vsdmKvnr = new VsdmKvnr("1234567890");
        Assertions.assertNotEquals(null, (Object)vsdmKvnr);
    }

    @Test
    void shouldReturnSameHashCodeForEqualKvnrObjects() {
        VsdmKvnr vsdmKvnr1 = new VsdmKvnr("1234567890");
        VsdmKvnr vsdmKvnr2 = new VsdmKvnr("1234567890");
        Assertions.assertEquals((int)vsdmKvnr1.hashCode(), (int)vsdmKvnr2.hashCode());
    }

    @Test
    void shouldReturnDifferentHashCodeForNonEqualKvnrObjects() {
        VsdmKvnr vsdmKvnr1 = new VsdmKvnr("1234567890");
        VsdmKvnr vsdmKvnr2 = new VsdmKvnr("0987654321");
        Assertions.assertNotEquals((int)vsdmKvnr1.hashCode(), (int)vsdmKvnr2.hashCode());
    }
}

