/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.VsdmUtils;
import de.gematik.bbriccs.vsdm.exceptions.InvalidKeyLengthException;
import de.gematik.bbriccs.vsdm.types.VsdmKey;
import de.gematik.bbriccs.vsdm.types.VsdmKeyVersion;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.params.KeyParameter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class VsdmKeyTest {
    VsdmKeyTest() {
    }

    @Test
    void shouldThrowExceptionForInvalidKeyLength() {
        byte[] invalidKey = new byte[16];
        VsdmKeyVersion keyVersion = new VsdmKeyVersion('1', VsdmCheckDigitVersion.V1);
        Assertions.assertThrows(InvalidKeyLengthException.class, () -> new VsdmKey(invalidKey, keyVersion));
    }

    @Test
    void shouldReturnKeyParameterForVersion1() {
        byte[] validKey = new byte[32];
        VsdmKey vsdmKey = new VsdmKey(validKey, new VsdmKeyVersion('1', VsdmCheckDigitVersion.V1));
        KeyParameter keyParameter = vsdmKey.getKeyForVersion1();
        Assertions.assertArrayEquals((byte[])validKey, (byte[])keyParameter.getKey());
    }

    @Test
    void shouldDeriveAesKeyForVersion2() {
        byte[] validKey = new byte[32];
        validKey[31] = 1;
        VsdmKey vsdmKey = new VsdmKey(validKey, new VsdmKeyVersion('2', VsdmCheckDigitVersion.V2));
        SecretKeySpec aesKey = vsdmKey.getKeyForVersion2();
        Assertions.assertEquals((int)16, (int)aesKey.getEncoded().length);
        Assertions.assertEquals((Object)"AES", (Object)aesKey.getAlgorithm());
        Assertions.assertEquals((Object)"B4 53 CD 39 EA 09 DB C3 A4 FF 47 EB C8 BB BF B2".replace(" ", ""), (Object)VsdmUtils.bytesToHex((byte[])aesKey.getEncoded()).replace(" ", ""));
    }

    @Test
    void shouldThrowExceptionForNullKey() {
        VsdmKeyVersion keyVersion = new VsdmKeyVersion('1', VsdmCheckDigitVersion.V1);
        Assertions.assertThrows(NullPointerException.class, () -> new VsdmKey(null, keyVersion));
    }

    @Test
    void shouldEquals() {
        byte[] validKey = new byte[32];
        VsdmKey vsdmKey1 = new VsdmKey(validKey, new VsdmKeyVersion('2', VsdmCheckDigitVersion.V2));
        VsdmKey vsdmKey2 = new VsdmKey(validKey, new VsdmKeyVersion('2', VsdmCheckDigitVersion.V2));
        Assertions.assertDoesNotThrow(() -> vsdmKey1.equals((Object)vsdmKey2));
        Assertions.assertDoesNotThrow(() -> vsdmKey1.equals((Object)""));
        Assertions.assertDoesNotThrow(() -> vsdmKey1.equals((Object)vsdmKey1));
        Assertions.assertNotEquals((Object)"", (Object)vsdmKey1);
        Assertions.assertDoesNotThrow(() -> ((VsdmKey)vsdmKey1).hashCode());
        Assertions.assertDoesNotThrow(() -> ((VsdmKey)vsdmKey1).toString());
    }
}

