/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.exceptions.ParsingException;
import de.gematik.bbriccs.vsdm.types.VsdmIssuedAtTimestamp;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class VsdmIssuedAtTimestampTest {
    VsdmIssuedAtTimestampTest() {
    }

    @Test
    void shouldGenerateCorrectBytesForV1Version() {
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = new VsdmIssuedAtTimestamp(Instant.ofEpochSecond(1609459200L), VsdmCheckDigitVersion.V1);
        byte[] result = vsdmIssuedAtTimestamp.generate();
        Assertions.assertArrayEquals((byte[])"1609459200".getBytes(StandardCharsets.UTF_8), (byte[])result);
    }

    @Test
    void shouldGenerateCorrectBytesForV2Version() {
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = new VsdmIssuedAtTimestamp(Instant.parse("2025-01-01T00:00:00Z"), VsdmCheckDigitVersion.V2);
        byte[] result = vsdmIssuedAtTimestamp.generate();
        Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 0}, (byte[])result);
    }

    @Test
    void shouldParseCorrectTimestampForV1Version() {
        byte[] data = "00000000001609459200".getBytes(StandardCharsets.UTF_8);
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = VsdmIssuedAtTimestamp.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V1);
        Assertions.assertEquals((Object)Instant.ofEpochSecond(1609459200L), (Object)vsdmIssuedAtTimestamp.getTimestamp());
    }

    @Test
    void shouldParseCorrectTimestampForV2Version() {
        VsdmIssuedAtTimestamp issued = new VsdmIssuedAtTimestamp(Instant.parse("2025-01-01T00:00:00Z"), VsdmCheckDigitVersion.V2);
        byte[] issuedBytes = issued.generate();
        byte[] data = new byte[]{issuedBytes[0], issuedBytes[0], issuedBytes[0], issuedBytes[0], issuedBytes[0], issuedBytes[1], issuedBytes[2], issuedBytes[0]};
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = VsdmIssuedAtTimestamp.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V2);
        Assertions.assertEquals((Object)Instant.parse("2025-01-01T00:00:00Z"), (Object)vsdmIssuedAtTimestamp.getTimestamp());
    }

    @Test
    void shouldThrowParsingExceptionForInvalidDataV1() {
        byte[] data = new byte[]{0};
        Assertions.assertThrows(ParsingException.class, () -> VsdmIssuedAtTimestamp.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V1));
    }

    @Test
    void shouldThrowParsingExceptionForInvalidDataV2() {
        byte[] data = new byte[]{0};
        Assertions.assertThrows(ParsingException.class, () -> VsdmIssuedAtTimestamp.parse((byte[])data, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V2));
    }

    @Test
    void shouldReturnNegativeOneWhenTimestampIsTooOld() {
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = new VsdmIssuedAtTimestamp(Instant.now().minus(21L, ChronoUnit.MINUTES), VsdmCheckDigitVersion.V2);
        Assertions.assertEquals((int)-1, (int)vsdmIssuedAtTimestamp.compareIatTimestampWith(Instant.now()));
    }

    @Test
    void shouldReturnOneWhenTimestampIsInTheFuture() {
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = new VsdmIssuedAtTimestamp(Instant.now().plus(1L, ChronoUnit.MINUTES), VsdmCheckDigitVersion.V2);
        Assertions.assertEquals((int)1, (int)vsdmIssuedAtTimestamp.compareIatTimestampWith(Instant.now()));
    }

    @Test
    void shouldReturnZeroWhenTimestampIsWithinValidRange() {
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = new VsdmIssuedAtTimestamp(Instant.now(), VsdmCheckDigitVersion.V2);
        Assertions.assertEquals((int)0, (int)vsdmIssuedAtTimestamp.compareIatTimestampWith(Instant.now()));
    }

    @Test
    void shouldNotThrownNullpointer() {
        Assertions.assertDoesNotThrow(() -> new VsdmIssuedAtTimestamp(VsdmCheckDigitVersion.V2));
    }

    @Test
    void shouldThrowExceptionForNullDataInParse() {
        Assertions.assertThrows(ParsingException.class, () -> VsdmIssuedAtTimestamp.parse(null, (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V1));
    }

    @Test
    void shouldReturnNegativeOneWhenTimestampIsExactly21MinutesOld() {
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = new VsdmIssuedAtTimestamp(Instant.now().minus(21L, ChronoUnit.MINUTES), VsdmCheckDigitVersion.V1);
        Assertions.assertEquals((int)-1, (int)vsdmIssuedAtTimestamp.compareIatTimestampWith(Instant.now()));
    }

    @Test
    void shouldReturnOneWhenTimestampIsExactlyOneMinuteInTheFuture() {
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = new VsdmIssuedAtTimestamp(Instant.now().plus(1L, ChronoUnit.MINUTES), VsdmCheckDigitVersion.V1);
        Assertions.assertEquals((int)1, (int)vsdmIssuedAtTimestamp.compareIatTimestampWith(Instant.now()));
    }

    @Test
    void shouldReturnZeroWhenTimestampIsExactlyNow() {
        VsdmIssuedAtTimestamp vsdmIssuedAtTimestamp = new VsdmIssuedAtTimestamp(Instant.now(), VsdmCheckDigitVersion.V2);
        Assertions.assertEquals((int)0, (int)vsdmIssuedAtTimestamp.compareIatTimestampWith(Instant.now()));
    }
}

