/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.exceptions;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.exceptions.ParsingVersionException;
import de.gematik.bbriccs.vsdm.types.VsdmKeyVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParsingVersionExceptionTest {
    ParsingVersionExceptionTest() {
    }

    @Test
    void shouldCreateParsingVersionExceptionWithCheckDigitVersion() {
        VsdmCheckDigitVersion expectedVersion = VsdmCheckDigitVersion.V1;
        VsdmCheckDigitVersion actualVersion = VsdmCheckDigitVersion.V2;
        ParsingVersionException exception = new ParsingVersionException(expectedVersion, actualVersion);
        Assertions.assertNotNull((Object)exception);
        Assertions.assertEquals((Object)"The checksum should contain version 'V1', but it contains 'V2'.", (Object)exception.getMessage());
    }

    @Test
    void shouldCreateParsingVersionExceptionWithKeyVersion() {
        VsdmKeyVersion expectedVersion = new VsdmKeyVersion('1', VsdmCheckDigitVersion.V1);
        VsdmKeyVersion actualVersion = new VsdmKeyVersion('2', VsdmCheckDigitVersion.V1);
        ParsingVersionException exception = new ParsingVersionException(expectedVersion, actualVersion);
        Assertions.assertNotNull((Object)exception);
        Assertions.assertEquals((Object)"Check digit should be encrypted with key version '1'. Instead, key version '2' was used", (Object)exception.getMessage());
    }
}

